/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Include
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean myImmutable;
    private boolean myRecurse;
    private String myValue;

    public Include(String theValue) {
        this.myValue = theValue;
        this.myImmutable = false;
    }

    public Include(String theValue, boolean theRecurse) {
        this.myValue = theValue;
        this.myRecurse = theRecurse;
        this.myImmutable = false;
    }

    public Include(String theValue, boolean theRecurse, boolean theImmutable) {
        this.myValue = theValue;
        this.myRecurse = theRecurse;
        this.myImmutable = theImmutable;
    }

    public Include asNonRecursive() {
        return new Include(this.myValue, false);
    }

    public Include asRecursive() {
        return new Include(this.myValue, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Include other = (Include)obj;
        if (this.myRecurse != other.myRecurse) {
            return false;
        }
        return !(this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue));
    }

    public String getParamType() {
        int firstColon = this.myValue.indexOf(58);
        if (firstColon == -1 || firstColon == this.myValue.length() - 1) {
            return null;
        }
        return this.myValue.substring(0, firstColon);
    }

    public String getParamName() {
        int firstColon = this.myValue.indexOf(58);
        if (firstColon == -1 || firstColon == this.myValue.length() - 1) {
            return null;
        }
        int secondColon = this.myValue.indexOf(58, firstColon + 1);
        if (secondColon != -1) {
            return this.myValue.substring(firstColon + 1, secondColon);
        }
        return this.myValue.substring(firstColon + 1);
    }

    public String getParamTargetType() {
        int firstColon = this.myValue.indexOf(58);
        if (firstColon == -1 || firstColon == this.myValue.length() - 1) {
            return null;
        }
        int secondColon = this.myValue.indexOf(58, firstColon + 1);
        if (secondColon != -1) {
            return this.myValue.substring(secondColon + 1);
        }
        return null;
    }

    public String getValue() {
        return this.myValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myRecurse ? 1231 : 1237);
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        return result;
    }

    public boolean isLocked() {
        return this.myImmutable;
    }

    public boolean isRecurse() {
        return this.myRecurse;
    }

    public Include setRecurse(boolean theRecurse) {
        this.myRecurse = theRecurse;
        return this;
    }

    public void setValue(String theValue) {
        if (this.myImmutable) {
            throw new IllegalStateException("Can not change the value of this include");
        }
        this.myValue = theValue;
    }

    public Include toLocked() {
        Include retVal = new Include(this.myValue, this.myRecurse, true);
        return retVal;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("value", (Object)this.myValue);
        builder.append("recurse", this.myRecurse);
        return builder.toString();
    }

    public Include withType(String theResourceType) {
        StringBuilder b = new StringBuilder();
        String paramType = this.getParamType();
        String paramName = this.getParamName();
        if (StringUtils.isBlank((CharSequence)paramType) || StringUtils.isBlank((CharSequence)paramName)) {
            throw new IllegalStateException("This include does not contain a value in the format [ResourceType]:[paramName]");
        }
        b.append(paramType);
        b.append(":");
        b.append(paramName);
        if (StringUtils.isNotBlank((CharSequence)theResourceType)) {
            b.append(':');
            b.append(theResourceType);
        }
        Include retVal = new Include(b.toString(), this.myRecurse, this.myImmutable);
        return retVal;
    }
}

