/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(VersionUtil.class);
    private static String ourVersion;

    public static String getVersion() {
        return ourVersion;
    }

    private static void initialize() {
        try (InputStream is = VersionUtil.class.getResourceAsStream("/ca/uhn/fhir/hapi-version.properties");){
            Properties p = new Properties();
            p.load(is);
            ourVersion = p.getProperty("version");
            ourLog.info("HAPI FHIR version is: " + ourVersion);
        }
        catch (Exception e) {
            ourLog.warn("Unable to determine HAPI version information", (Throwable)e);
        }
    }

    static {
        VersionUtil.initialize();
    }
}

