/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.context.RuntimeChildDirectResource;
import ca.uhn.fhir.context.RuntimeExtensionDtDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ISupportsUndeclaredExtensions;
import ca.uhn.fhir.model.base.composite.BaseContainedDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.util.IModelVisitor;
import ca.uhn.fhir.util.IModelVisitor2;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class FhirTerser {
    private FhirContext myContext;

    public FhirTerser(FhirContext theContext) {
        this.myContext = theContext;
    }

    private List<String> addNameToList(List<String> theCurrentList, BaseRuntimeChildDefinition theChildDefinition) {
        if (theChildDefinition == null) {
            return null;
        }
        if (theCurrentList == null || theCurrentList.isEmpty()) {
            return new ArrayList<String>(Arrays.asList(theChildDefinition.getElementName()));
        }
        ArrayList<String> newList = new ArrayList<String>(theCurrentList);
        newList.add(theChildDefinition.getElementName());
        return newList;
    }

    public void cloneInto(IBase theSource, IBase theTarget, boolean theIgnoreMissingFields) {
        Validate.notNull((Object)theSource, (String)"theSource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theTarget, (String)"theTarget must not be null", (Object[])new Object[0]);
        if (theSource instanceof IPrimitiveType) {
            if (theTarget instanceof IPrimitiveType) {
                ((IPrimitiveType)theTarget).setValueAsString(((IPrimitiveType)theSource).getValueAsString());
                return;
            }
            if (theIgnoreMissingFields) {
                return;
            }
            throw new DataFormatException("Can not copy value from primitive of type " + theSource.getClass().getName() + " into type " + theTarget.getClass().getName());
        }
        BaseRuntimeElementCompositeDefinition sourceDef = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(theSource.getClass());
        BaseRuntimeElementCompositeDefinition targetDef = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(theTarget.getClass());
        List<BaseRuntimeChildDefinition> children = sourceDef.getChildren();
        if (sourceDef instanceof RuntimeExtensionDtDefinition) {
            children = ((RuntimeExtensionDtDefinition)sourceDef).getChildrenIncludingUrl();
        }
        for (BaseRuntimeChildDefinition nextChild : children) {
            for (IBase nextValue : nextChild.getAccessor().getValues(theSource)) {
                String elementName = nextChild.getChildNameByDatatype(nextValue.getClass());
                BaseRuntimeChildDefinition targetChild = targetDef.getChildByName(elementName);
                if (targetChild == null) {
                    if (theIgnoreMissingFields) continue;
                    throw new DataFormatException("Type " + theTarget.getClass().getName() + " does not have a child with name " + elementName);
                }
                BaseRuntimeElementDefinition<?> childDef = targetChild.getChildByName(elementName);
                Object target = childDef.newInstance();
                targetChild.getMutator().addValue(theTarget, (IBase)target);
                this.cloneInto(nextValue, (IBase)target, theIgnoreMissingFields);
            }
        }
    }

    public <T extends IBase> List<T> getAllPopulatedChildElementsOfType(IBaseResource theResource, final Class<T> theType) {
        final ArrayList retVal = new ArrayList();
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        this.visit(new IdentityHashMap<Object, Object>(), theResource, theResource, null, null, def, new IModelVisitor(){

            @Override
            public void acceptElement(IBaseResource theOuterResource, IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition) {
                if (theElement == null || theElement.isEmpty()) {
                    return;
                }
                if (theType.isAssignableFrom(theElement.getClass())) {
                    retVal.add(theElement);
                }
            }
        });
        return retVal;
    }

    public List<ResourceReferenceInfo> getAllResourceReferences(IBaseResource theResource) {
        final ArrayList<ResourceReferenceInfo> retVal = new ArrayList<ResourceReferenceInfo>();
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        this.visit(new IdentityHashMap<Object, Object>(), theResource, theResource, null, null, def, new IModelVisitor(){

            @Override
            public void acceptElement(IBaseResource theOuterResource, IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition) {
                if (theElement == null || theElement.isEmpty()) {
                    return;
                }
                if (IBaseReference.class.isAssignableFrom(theElement.getClass())) {
                    retVal.add(new ResourceReferenceInfo(FhirTerser.this.myContext, theOuterResource, thePathToElement, (IBaseReference)theElement));
                }
            }
        });
        return retVal;
    }

    private BaseRuntimeChildDefinition getDefinition(BaseRuntimeElementCompositeDefinition<?> theCurrentDef, List<String> theSubList) {
        BaseRuntimeChildDefinition nextDef = theCurrentDef.getChildByNameOrThrowDataFormatException(theSubList.get(0));
        if (theSubList.size() == 1) {
            return nextDef;
        }
        BaseRuntimeElementCompositeDefinition cmp = (BaseRuntimeElementCompositeDefinition)nextDef.getChildByName(theSubList.get(0));
        return this.getDefinition(cmp, theSubList.subList(1, theSubList.size()));
    }

    public BaseRuntimeChildDefinition getDefinition(Class<? extends IBaseResource> theResourceType, String thePath) {
        RuntimeResourceDefinition def;
        RuntimeResourceDefinition currentDef = def = this.myContext.getResourceDefinition(theResourceType);
        List<String> parts = Arrays.asList(thePath.split("\\."));
        List<String> subList = parts.subList(1, parts.size());
        if (subList.size() < 1) {
            throw new ConfigurationException("Invalid path: " + thePath);
        }
        return this.getDefinition(currentDef, subList);
    }

    public Object getSingleValueOrNull(IBase theTarget, String thePath) {
        Class<Object> wantedType = Object.class;
        return this.getSingleValueOrNull(theTarget, thePath, wantedType);
    }

    public <T> T getSingleValueOrNull(IBase theTarget, String thePath, Class<T> theWantedType) {
        Validate.notNull((Object)theTarget, (String)"theTarget must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)thePath, (String)"thePath must not be empty", (Object[])new Object[0]);
        BaseRuntimeElementDefinition<?> def = this.myContext.getElementDefinition(theTarget.getClass());
        if (!(def instanceof BaseRuntimeElementCompositeDefinition)) {
            throw new IllegalArgumentException("Target is not a composite type: " + theTarget.getClass().getName());
        }
        BaseRuntimeElementCompositeDefinition currentDef = (BaseRuntimeElementCompositeDefinition)def;
        IBase currentObj = theTarget;
        List<String> parts = this.parsePath(currentDef, thePath);
        List<T> retVal = this.getValues(currentDef, currentObj, parts, theWantedType);
        if (retVal.isEmpty()) {
            return null;
        }
        return retVal.get(0);
    }

    private <T> List<T> getValues(BaseRuntimeElementCompositeDefinition<?> theCurrentDef, Object theCurrentObj, List<String> theSubList, Class<T> theWantedClass) {
        String name = theSubList.get(0);
        ArrayList<IBase> retVal = new ArrayList<IBase>();
        if (name.startsWith("extension('")) {
            String extensionUrl = name.substring("extension('".length());
            int endIndex = extensionUrl.indexOf(39);
            if (endIndex != -1) {
                extensionUrl = extensionUrl.substring(0, endIndex);
            }
            List<Object> extensions = Collections.emptyList();
            if (theCurrentObj instanceof ISupportsUndeclaredExtensions) {
                extensions = ((ISupportsUndeclaredExtensions)theCurrentObj).getUndeclaredExtensionsByUrl(extensionUrl);
            } else if (theCurrentObj instanceof IBaseExtension) {
                extensions = ((IBaseExtension)theCurrentObj).getExtension();
            }
            for (Object next : extensions) {
                if (!theWantedClass.isAssignableFrom(next.getClass())) continue;
                retVal.add((IBase)next);
            }
            if (theSubList.size() > 1) {
                ArrayList<IBase> values = retVal;
                retVal = new ArrayList();
                for (Object e : values) {
                    BaseRuntimeElementCompositeDefinition nextChildDef = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(e.getClass());
                    List<T> foundValues = this.getValues(nextChildDef, e, theSubList.subList(1, theSubList.size()), theWantedClass);
                    retVal.addAll(foundValues);
                }
            }
            return retVal;
        }
        BaseRuntimeChildDefinition nextDef = theCurrentDef.getChildByNameOrThrowDataFormatException(name);
        List<IBase> values = nextDef.getAccessor().getValues(theCurrentObj);
        if (theSubList.size() == 1) {
            if (nextDef instanceof RuntimeChildChoiceDefinition) {
                for (IBase next : values) {
                    if (next == null) continue;
                    if (name.endsWith("[x]")) {
                        if (theWantedClass != null && !theWantedClass.isAssignableFrom(next.getClass())) continue;
                        retVal.add(next);
                        continue;
                    }
                    String childName = nextDef.getChildNameByDatatype(next.getClass());
                    if (!theSubList.get(0).equals(childName) || theWantedClass != null && !theWantedClass.isAssignableFrom(next.getClass())) continue;
                    retVal.add(next);
                }
            } else {
                for (IBase next : values) {
                    if (next == null || theWantedClass != null && !theWantedClass.isAssignableFrom(next.getClass())) continue;
                    retVal.add(next);
                }
            }
        } else {
            for (IBase nextElement : values) {
                BaseRuntimeElementCompositeDefinition nextChildDef = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(nextElement.getClass());
                List<T> list = this.getValues(nextChildDef, nextElement, theSubList.subList(1, theSubList.size()), theWantedClass);
                retVal.addAll(list);
            }
        }
        return retVal;
    }

    public List<Object> getValues(IBaseResource theResource, String thePath) {
        Class<Object> wantedClass = Object.class;
        return this.getValues(theResource, thePath, wantedClass);
    }

    public <T> List<T> getValues(IBaseResource theResource, String thePath, Class<T> theWantedClass) {
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        List<String> parts = this.parsePath(def, thePath);
        return this.getValues(def, theResource, parts, theWantedClass);
    }

    private List<String> parsePath(BaseRuntimeElementCompositeDefinition<?> theElementDef, String thePath) {
        List<String> parts = new ArrayList<String>();
        int currentStart = 0;
        boolean inSingleQuote = false;
        block4: for (int i = 0; i < thePath.length(); ++i) {
            switch (thePath.charAt(i)) {
                case '\'': {
                    inSingleQuote = !inSingleQuote;
                    continue block4;
                }
                case '.': {
                    if (inSingleQuote) continue block4;
                    parts.add(thePath.substring(currentStart, i));
                    currentStart = i + 1;
                }
            }
        }
        parts.add(thePath.substring(currentStart));
        if (theElementDef instanceof RuntimeResourceDefinition && parts.size() > 0 && ((String)parts.get(0)).equals(theElementDef.getName())) {
            parts = parts.subList(1, parts.size());
        }
        if (parts.size() < 1) {
            throw new ConfigurationException("Invalid path: " + thePath);
        }
        return parts;
    }

    public boolean isSourceInCompartmentForTarget(String theCompartmentName, IBaseResource theSource, IIdType theTarget) {
        Validate.notBlank((CharSequence)theCompartmentName, (String)"theCompartmentName must not be null or blank", (Object[])new Object[0]);
        Validate.notNull((Object)theSource, (String)"theSource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theTarget, (String)"theTarget must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)StringUtils.defaultString((String)theTarget.getResourceType()), (String)"theTarget must have a populated resource type (theTarget.getResourceType() does not return a value)", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)StringUtils.defaultString((String)theTarget.getIdPart()), (String)"theTarget must have a populated ID (theTarget.getIdPart() does not return a value)", (Object[])new Object[0]);
        String wantRef = theTarget.toUnqualifiedVersionless().getValue();
        RuntimeResourceDefinition sourceDef = this.myContext.getResourceDefinition(theSource);
        if (theSource.getIdElement().hasIdPart() && wantRef.equals(sourceDef.getName() + '/' + theSource.getIdElement().getIdPart())) {
            return true;
        }
        List<RuntimeSearchParam> params = sourceDef.getSearchParamsForCompartmentName(theCompartmentName);
        for (RuntimeSearchParam nextParam : params) {
            for (String nextPath : nextParam.getPathsSplit()) {
                for (IBaseReference nextValue : this.getValues(theSource, nextPath, IBaseReference.class)) {
                    String nextRef = nextValue.getReferenceElement().toUnqualifiedVersionless().getValue();
                    if (StringUtils.isBlank((CharSequence)nextRef) && nextValue.getResource() != null) {
                        IBaseResource nextTarget = nextValue.getResource();
                        IIdType nextTargetId = nextTarget.getIdElement().toUnqualifiedVersionless();
                        if (!nextTargetId.hasResourceType()) {
                            String resourceType = this.myContext.getResourceDefinition(nextTarget).getName();
                            nextTargetId.setParts(null, resourceType, nextTargetId.getIdPart(), null);
                        }
                        nextRef = nextTargetId.getValue();
                    }
                    if (!wantRef.equals(nextRef)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void visit(IBase theElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition, IModelVisitor2 theCallback, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
        if (theChildDefinition != null) {
            theChildDefinitionPath.add(theChildDefinition);
        }
        theContainingElementPath.add(theElement);
        theElementDefinitionPath.add(theDefinition);
        theCallback.acceptElement(theElement, Collections.unmodifiableList(theContainingElementPath), Collections.unmodifiableList(theChildDefinitionPath), Collections.unmodifiableList(theElementDefinitionPath));
        if (theElement instanceof ISupportsUndeclaredExtensions) {
            ISupportsUndeclaredExtensions containingElement = (ISupportsUndeclaredExtensions)theElement;
            for (ExtensionDt extensionDt : containingElement.getUndeclaredExtensions()) {
                theContainingElementPath.add(extensionDt);
                theCallback.acceptUndeclaredExtension(extensionDt, theContainingElementPath, theChildDefinitionPath, theElementDefinitionPath);
                theContainingElementPath.remove(theContainingElementPath.size() - 1);
            }
        }
        switch (theDefinition.getChildType()) {
            case ID_DATATYPE: 
            case PRIMITIVE_XHTML_HL7ORG: 
            case PRIMITIVE_XHTML: 
            case PRIMITIVE_DATATYPE: {
                break;
            }
            case RESOURCE: 
            case RESOURCE_BLOCK: 
            case COMPOSITE_DATATYPE: {
                BaseRuntimeElementCompositeDefinition childDef = (BaseRuntimeElementCompositeDefinition)theDefinition;
                for (BaseRuntimeChildDefinition baseRuntimeChildDefinition : childDef.getChildrenAndExtension()) {
                    List<IBase> values = baseRuntimeChildDefinition.getAccessor().getValues(theElement);
                    if (values == null) continue;
                    for (IBase nextValue : values) {
                        if (nextValue == null || nextValue.isEmpty()) continue;
                        BaseRuntimeElementDefinition<?> childElementDef = baseRuntimeChildDefinition.getChildElementDefinitionByDatatype(nextValue.getClass());
                        if (childElementDef == null) {
                            StringBuilder b = new StringBuilder();
                            b.append("Found value of type[");
                            b.append(nextValue.getClass().getSimpleName());
                            b.append("] which is not valid for field[");
                            b.append(baseRuntimeChildDefinition.getElementName());
                            b.append("] in ");
                            b.append(childDef.getName());
                            b.append(" - Valid types: ");
                            Iterator<String> iter = new TreeSet<String>(baseRuntimeChildDefinition.getValidChildNames()).iterator();
                            while (iter.hasNext()) {
                                BaseRuntimeElementDefinition<?> childByName = baseRuntimeChildDefinition.getChildByName(iter.next());
                                b.append(childByName.getImplementingClass().getSimpleName());
                                if (!iter.hasNext()) continue;
                                b.append(", ");
                            }
                            throw new DataFormatException(b.toString());
                        }
                        if (baseRuntimeChildDefinition instanceof RuntimeChildDirectResource) {
                            theContainingElementPath.add(nextValue);
                            theChildDefinitionPath.add(baseRuntimeChildDefinition);
                            theElementDefinitionPath.add(this.myContext.getElementDefinition(nextValue.getClass()));
                            theCallback.acceptElement(nextValue, Collections.unmodifiableList(theContainingElementPath), Collections.unmodifiableList(theChildDefinitionPath), Collections.unmodifiableList(theElementDefinitionPath));
                            theChildDefinitionPath.remove(theChildDefinitionPath.size() - 1);
                            theContainingElementPath.remove(theContainingElementPath.size() - 1);
                            theElementDefinitionPath.remove(theElementDefinitionPath.size() - 1);
                            continue;
                        }
                        this.visit(nextValue, baseRuntimeChildDefinition, childElementDef, theCallback, theContainingElementPath, theChildDefinitionPath, theElementDefinitionPath);
                    }
                }
                break;
            }
            case CONTAINED_RESOURCES: {
                BaseContainedDt value = (BaseContainedDt)theElement;
                for (IResource iResource : value.getContainedResources()) {
                    RuntimeResourceDefinition def = this.myContext.getResourceDefinition(iResource);
                    this.visit(iResource, null, def, theCallback, theContainingElementPath, theChildDefinitionPath, theElementDefinitionPath);
                }
                break;
            }
            case EXTENSION_DECLARED: 
            case UNDECL_EXT: {
                throw new IllegalStateException("state should not happen: " + (Object)((Object)theDefinition.getChildType()));
            }
            case CONTAINED_RESOURCE_LIST: {
                if (theElement == null) break;
                BaseRuntimeElementDefinition<?> def = this.myContext.getElementDefinition(theElement.getClass());
                this.visit(theElement, null, def, theCallback, theContainingElementPath, theChildDefinitionPath, theElementDefinitionPath);
            }
        }
        if (theChildDefinition != null) {
            theChildDefinitionPath.remove(theChildDefinitionPath.size() - 1);
        }
        theContainingElementPath.remove(theContainingElementPath.size() - 1);
        theElementDefinitionPath.remove(theElementDefinitionPath.size() - 1);
    }

    public void visit(IBaseResource theResource, IModelVisitor theVisitor) {
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        this.visit(new IdentityHashMap<Object, Object>(), theResource, theResource, null, null, def, theVisitor);
    }

    void visit(IBaseResource theResource, IModelVisitor2 theVisitor) {
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        this.visit(theResource, null, def, theVisitor, new ArrayList<IBase>(), new ArrayList<BaseRuntimeChildDefinition>(), new ArrayList());
    }

    private void visit(IdentityHashMap<Object, Object> theStack, IBaseResource theResource, IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition, IModelVisitor theCallback) {
        IBaseResource target;
        List<String> pathToElement = this.addNameToList(thePathToElement, theChildDefinition);
        if (theStack.put(theElement, theElement) != null) {
            return;
        }
        theCallback.acceptElement(theResource, theElement, pathToElement, theChildDefinition, theDefinition);
        BaseRuntimeElementDefinition def = theDefinition;
        if (def.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.CONTAINED_RESOURCE_LIST) {
            def = this.myContext.getElementDefinition(theElement.getClass());
        }
        if (theElement instanceof IBaseReference && (target = ((IBaseReference)theElement).getResource()) != null && (!target.getIdElement().hasIdPart() || target.getIdElement().isLocal())) {
            RuntimeResourceDefinition targetDef = this.myContext.getResourceDefinition(target);
            this.visit(theStack, target, target, pathToElement, null, targetDef, theCallback);
        }
        switch (def.getChildType()) {
            case ID_DATATYPE: 
            case PRIMITIVE_XHTML_HL7ORG: 
            case PRIMITIVE_XHTML: 
            case PRIMITIVE_DATATYPE: {
                break;
            }
            case RESOURCE: 
            case RESOURCE_BLOCK: 
            case COMPOSITE_DATATYPE: {
                BaseRuntimeElementCompositeDefinition childDef = (BaseRuntimeElementCompositeDefinition)def;
                for (BaseRuntimeChildDefinition baseRuntimeChildDefinition : childDef.getChildrenAndExtension()) {
                    List<IBase> values = baseRuntimeChildDefinition.getAccessor().getValues(theElement);
                    if (values == null) continue;
                    for (IBase nextValueObject : values) {
                        IBase nextValue;
                        try {
                            nextValue = nextValueObject;
                        }
                        catch (ClassCastException e) {
                            String s = "Found instance of " + nextValueObject.getClass() + " - Did you set a field value to the incorrect type? Expected " + IBase.class.getName();
                            throw new ClassCastException(s);
                        }
                        if (nextValue == null || nextValue.isEmpty()) continue;
                        BaseRuntimeElementDefinition<?> childElementDef = baseRuntimeChildDefinition.getChildElementDefinitionByDatatype(nextValue.getClass());
                        if (childElementDef == null) {
                            childElementDef = this.myContext.getElementDefinition(nextValue.getClass());
                        }
                        if (baseRuntimeChildDefinition instanceof RuntimeChildDirectResource) {
                            theCallback.acceptElement(theResource, nextValue, null, baseRuntimeChildDefinition, childElementDef);
                            continue;
                        }
                        this.visit(theStack, theResource, nextValue, pathToElement, baseRuntimeChildDefinition, childElementDef, theCallback);
                    }
                }
                break;
            }
            case CONTAINED_RESOURCES: {
                BaseContainedDt value = (BaseContainedDt)theElement;
                for (IResource iResource : value.getContainedResources()) {
                    def = this.myContext.getResourceDefinition(iResource);
                    this.visit(theStack, iResource, iResource, pathToElement, null, def, theCallback);
                }
                break;
            }
            case EXTENSION_DECLARED: 
            case UNDECL_EXT: 
            case CONTAINED_RESOURCE_LIST: {
                throw new IllegalStateException("state should not happen: " + (Object)((Object)def.getChildType()));
            }
        }
        theStack.remove(theElement);
    }
}

