/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.model.api.IFhirVersion;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;

public enum FhirVersionEnum {
    DSTU2("ca.uhn.fhir.model.dstu2.FhirDstu2", null, false, new Version("1.0.2")),
    DSTU2_HL7ORG("org.hl7.fhir.instance.FhirDstu2Hl7Org", DSTU2, true, new Version("1.0.2")),
    DSTU2_1("org.hl7.fhir.dstu2016may.hapi.ctx.FhirDstu2_1", null, true, new Version("1.4.0")),
    DSTU3("org.hl7.fhir.dstu3.hapi.ctx.FhirDstu3", null, true, new Dstu3Version()),
    R4("org.hl7.fhir.r4.hapi.ctx.FhirR4", null, true, new R4Version());

    private final FhirVersionEnum myEquivalent;
    private final boolean myIsRi;
    private volatile Boolean myPresentOnClasspath;
    private final String myVersionClass;
    private volatile IFhirVersion myVersionImplementation;
    private String myFhirVersionString;

    private FhirVersionEnum(String theVersionClass, FhirVersionEnum theEquivalent, boolean theIsRi, IVersionProvider theVersionExtractor) {
        this.myVersionClass = theVersionClass;
        this.myEquivalent = theEquivalent;
        this.myFhirVersionString = theVersionExtractor.provideVersion();
        this.myIsRi = theIsRi;
    }

    public String getFhirVersionString() {
        return this.myFhirVersionString;
    }

    public IFhirVersion getVersionImplementation() {
        if (!this.isPresentOnClasspath()) {
            throw new IllegalStateException("Version " + this.name() + " is not present on classpath");
        }
        if (this.myVersionImplementation == null) {
            try {
                this.myVersionImplementation = (IFhirVersion)Class.forName(this.myVersionClass).newInstance();
            }
            catch (Exception e) {
                throw new InternalErrorException("Failed to instantiate FHIR version " + this.name(), (Throwable)e);
            }
        }
        return this.myVersionImplementation;
    }

    public boolean isEqualOrNewerThan(FhirVersionEnum theVersion) {
        return this.ordinal() >= theVersion.ordinal();
    }

    public boolean isEquivalentTo(FhirVersionEnum theVersion) {
        if (this.equals((Object)theVersion)) {
            return true;
        }
        if (this.myEquivalent != null) {
            return this.myEquivalent.equals((Object)theVersion);
        }
        return false;
    }

    public boolean isNewerThan(FhirVersionEnum theVersion) {
        return !this.isEquivalentTo(theVersion) && this.ordinal() > theVersion.ordinal();
    }

    public boolean isOlderThan(FhirVersionEnum theVersion) {
        return !this.isEquivalentTo(theVersion) && this.ordinal() < theVersion.ordinal();
    }

    public boolean isPresentOnClasspath() {
        Boolean retVal = this.myPresentOnClasspath;
        if (retVal == null) {
            try {
                Class.forName(this.myVersionClass);
                retVal = true;
            }
            catch (Exception e) {
                retVal = false;
            }
            this.myPresentOnClasspath = retVal;
        }
        return retVal;
    }

    public boolean isRi() {
        return this.myIsRi;
    }

    private static class R4Version
    implements IVersionProvider {
        private String myVersion;

        public R4Version() {
            try {
                Class<?> c = Class.forName("org.hl7.fhir.r4.model.Constants");
                this.myVersion = (String)c.getDeclaredField("VERSION").get(null);
            }
            catch (Exception e) {
                this.myVersion = "4.0.0";
            }
        }

        @Override
        public String provideVersion() {
            return this.myVersion;
        }
    }

    private static class Dstu3Version
    implements IVersionProvider {
        private String myVersion;

        public Dstu3Version() {
            try {
                Class<?> c = Class.forName("org.hl7.fhir.dstu3.model.Constants");
                this.myVersion = (String)c.getDeclaredField("VERSION").get(null);
            }
            catch (Exception e) {
                this.myVersion = "3.0.1";
            }
        }

        @Override
        public String provideVersion() {
            return this.myVersion;
        }
    }

    private static interface IVersionProvider {
        public String provideVersion();
    }

    private static class Version
    implements IVersionProvider {
        private String myVersion;

        public Version(String theVersion) {
            this.myVersion = theVersion;
        }

        @Override
        public String provideVersion() {
            return this.myVersion;
        }
    }
}

