/*
 * Decompiled with CFR 0.152.
 */
package black.door.util;

import java.util.ArrayList;

public class Statistics {
    public static double mean(Number[] population) {
        return Statistics.sum(population) / (double)population.length;
    }

    public static double stdDev(Number[] population) {
        double mean = Statistics.mean(population);
        Number[] diffs = new Double[population.length];
        for (int i = 0; i < population.length; ++i) {
            diffs[i] = Math.pow(population[i].doubleValue() - mean, 2.0);
        }
        return Math.sqrt(Statistics.mean(diffs));
    }

    public static double sum(Number[] population) {
        double sum = 0.0;
        for (Number point : population) {
            sum += point.doubleValue();
        }
        return sum;
    }

    public static Number[] discardOutliers(Number[] population, int stdDevs) {
        double stdDev = Statistics.stdDev(population);
        double mean = Statistics.mean(population);
        ArrayList<Number> reduced = new ArrayList<Number>();
        for (Number point : population) {
            if (!(point.doubleValue() < mean + stdDev * (double)stdDevs) || !(point.doubleValue() > mean - stdDev * (double)stdDevs)) continue;
            reduced.add(point);
        }
        return reduced.toArray(new Double[1]);
    }
}

