/*
 * Decompiled with CFR 0.152.
 */
package black.door.struct;

import black.door.struct.SortedArrayList;
import java.util.ArrayList;

public class GenericMap {
    private ArrayList<GenericEntry> values = new ArrayList();
    private SortedArrayList<String> keys = new SortedArrayList();
    public int size = 0;
    public boolean isEmpty = true;

    public void clear() {
        this.values.clear();
        this.keys.clear();
        this.size = 0;
        this.isEmpty = true;
    }

    public boolean containsKey(String key) {
        return this.keys.contains(key);
    }

    public boolean containsValue(Object value) {
        for (GenericEntry e : this.values) {
            if (!e.equals(value)) continue;
            return true;
        }
        return false;
    }

    private Object grab(String key) {
        return this.values.get((int)this.keys.indexOf((Object)key)).value;
    }

    public <T> T get(String key, Class<T> type) {
        return type.cast(this.grab(key));
    }

    public Object get(String key) {
        return this.grab(key);
    }

    public <T> Object put(String key, T value) {
        Object last = null;
        int index = this.keys.indexOf(key);
        if (index >= 0) {
            last = this.grab(key);
            this.values.remove(index);
            this.values.add(index, new GenericEntry<T>(value));
        } else {
            this.keys.addSorted(key);
            index = this.keys.indexOf(key);
            this.values.add(index, new GenericEntry<T>(value));
        }
        this.isEmpty = false;
        ++this.size;
        return last;
    }

    public Object remove(String key) {
        Object last = null;
        int index = this.keys.indexOf(key);
        if (this.keys.remove(key)) {
            last = this.values.remove((int)index).value;
            --this.size;
            if (this.size < 1) {
                this.isEmpty = true;
            }
        }
        return last;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericMap other = (GenericMap)obj;
        if (other.size != this.size) {
            return false;
        }
        if (this.keys == null ? other.keys != null : !this.keys.equals(other.keys)) {
            return false;
        }
        if (this.values == null) {
            if (other.values != null) {
                return false;
            }
        } else {
            int index = 0;
            for (String key : this.keys) {
                Class<?> type;
                if (!this.get(key, type = this.values.get((int)index).value.getClass()).equals(other.get(key, type))) {
                    return false;
                }
                ++index;
            }
        }
        return true;
    }

    public String toString() {
        String result = "";
        for (String key : this.keys) {
            result = result + key + ": " + this.grab(key) + "\n";
        }
        return result;
    }

    class GenericEntry<T> {
        public T value;

        public GenericEntry(T value) {
            this.value = value;
        }

        public String toString() {
            return this.value.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return this.value.equals(obj);
        }

        public T getValue() {
            return this.value;
        }
    }
}

