/*
 * Decompiled with CFR 0.152.
 */
package black.door.crypto;

import black.door.crypto.HistoricSHE;
import black.door.struct.ByteQueue;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;

public class EncryptedInputStream
extends FilterInputStream {
    private HistoricSHE cipher;
    private ByteQueue buffer;

    public EncryptedInputStream(InputStream in, HistoricSHE cipher) {
        super(in);
        if (!cipher.isConfigured()) {
            throw new RuntimeException("Cipher not configured.");
        }
        this.cipher = cipher;
        this.buffer = new ByteQueue(cipher.blockSize * 2);
        this.buffer.setResizable(true);
    }

    private void bufferBlock() throws IOException {
        byte[] plainText = new byte[this.cipher.blockSize];
        this.in.read(plainText);
        this.buffer.enQueue(this.cipher.update(plainText));
    }

    private void bufferBytes(int size) throws IOException {
        while (this.buffer.filled() < size) {
            this.bufferBlock();
        }
    }

    @Override
    public int read() throws IOException {
        try {
            return this.buffer.deQueue(1)[0];
        }
        catch (BufferUnderflowException e) {
            this.bufferBlock();
            return this.read();
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.bufferBytes(len - off);
        this.buffer.deQueue(b, off, len);
        return len - off;
    }
}

