/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.plugin;

import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.version.MavenVersion;
import aQute.bnd.version.Version;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.service.reporter.Report;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="bnd-process", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BndMavenPlugin
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(BndMavenPlugin.class);
    private static final String MANIFEST_LAST_MODIFIED = "aQute.bnd.maven.plugin.BndMavenPlugin.manifestLastModified";
    private static final String MARKED_FILES = "aQute.bnd.maven.plugin.BndMavenPlugin.markedFiles";
    private static final String PACKAGING_POM = "pom";
    private static final String TSTAMP = "${tstamp}";
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetDir;
    @Parameter(defaultValue="${project.build.sourceDirectory}", readonly=true)
    private File sourceDir;
    @Parameter(defaultValue="${project.build.resources}", readonly=true)
    private List<Resource> resources;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private File classesDir;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/MANIFEST.MF")
    private File manifestPath;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojoExecution;
    @Parameter(property="bnd.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="bnd.bnd")
    private String bndfile;
    @Parameter
    private String bnd;
    @Component
    private BuildContext buildContext;
    private File propertiesFile;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            logger.debug("skip project as configured");
            return;
        }
        if (PACKAGING_POM.equals(this.project.getPackaging())) {
            logger.info("skip project with packaging=pom");
            return;
        }
        BeanProperties beanProperties = new BeanProperties();
        beanProperties.put("project", this.project);
        beanProperties.put("settings", this.settings);
        Properties mavenProperties = new Properties(beanProperties);
        mavenProperties.putAll((Map<?, ?>)this.project.getProperties());
        try (Builder builder = new Builder(new Processor(mavenProperties, false));){
            builder.setTrace(logger.isDebugEnabled());
            builder.setBase(this.project.getBasedir());
            this.propertiesFile = this.loadProperties(builder);
            builder.setProperty("project.output", this.targetDir.getCanonicalPath());
            if (Processor.isTrue((String)builder.getProperty("-nobundles"))) {
                logger.debug("-nobundles: true");
                return;
            }
            List subs = builder.getSubBuilders();
            if (subs.size() != 1 || !builder.equals(subs.get(0))) {
                throw new MojoExecutionException("Sub-bundles not permitted in a maven build");
            }
            if (builder.getProperty("-wab") != null) {
                throw new MojoExecutionException("-wab not supported in a maven build");
            }
            if (builder.getProperty("-wablib") != null) {
                throw new MojoExecutionException("-wablib not supported in a maven build");
            }
            if (this.classesDir.isDirectory()) {
                Jar classesDirJar = new Jar(this.project.getName(), this.classesDir);
                classesDirJar.setManifest(new Manifest());
                builder.setJar(classesDirJar);
            }
            Set artifacts = this.project.getArtifacts();
            ArrayList<Object> buildpath = new ArrayList<Object>(artifacts.size());
            for (Artifact artifact : artifacts) {
                File cpe = artifact.getFile().getCanonicalFile();
                if (!cpe.exists()) {
                    logger.debug("dependency {} does not exist", (Object)cpe);
                    continue;
                }
                if (cpe.isDirectory()) {
                    Jar cpeJar = new Jar(cpe);
                    builder.addClose((Closeable)cpeJar);
                    builder.updateModified(cpeJar.lastModified(), cpe.getPath());
                    buildpath.add(cpeJar);
                    continue;
                }
                if (!artifact.getType().equals("jar")) {
                    try (ZipFile zip = new ZipFile(cpe);){
                        zip.entries();
                    }
                    catch (ZipException e) {
                        logger.debug("dependency {} is not a zip", (Object)cpe);
                        continue;
                    }
                }
                builder.updateModified(cpe.lastModified(), cpe.getPath());
                buildpath.add(cpe);
            }
            builder.setProperty("project.buildpath", Strings.join((String)File.pathSeparator, buildpath));
            logger.debug("builder classpath: {}", (Object)builder.getProperty("project.buildpath"));
            boolean delta = !this.buildContext.isIncremental() || this.manifestOutOfDate();
            ArrayList<File> sourcepath = new ArrayList<File>();
            if (this.sourceDir.exists()) {
                sourcepath.add(this.sourceDir.getCanonicalFile());
                delta |= this.buildContext.hasDelta(this.sourceDir);
            }
            for (Resource resource : this.resources) {
                File resourceDir = new File(resource.getDirectory());
                if (!resourceDir.exists()) continue;
                sourcepath.add(resourceDir.getCanonicalFile());
                delta |= this.buildContext.hasDelta(resourceDir);
            }
            builder.setProperty("project.sourcepath", Strings.join((String)File.pathSeparator, sourcepath));
            logger.debug("builder sourcepath: {}", (Object)builder.getProperty("project.sourcepath"));
            if (builder.getProperty("Bundle-SymbolicName") == null) {
                builder.setProperty("Bundle-SymbolicName", this.project.getArtifactId());
            }
            if (builder.getProperty("Bundle-Name") == null) {
                builder.setProperty("Bundle-Name", this.project.getName());
            }
            if (builder.getProperty("Bundle-Version") == null) {
                Version version = MavenVersion.parseString((String)this.project.getVersion()).getOSGiVersion();
                builder.setProperty("Bundle-Version", version.toString());
                if (builder.getProperty("-snapshot") == null) {
                    builder.setProperty("-snapshot", TSTAMP);
                }
            }
            logger.debug("builder properties: {}", (Object)builder.getProperties());
            logger.debug("builder delta: {}", (Object)delta);
            if (delta || builder.getJar() == null || builder.lastModified() > builder.getJar().lastModified()) {
                builder.setClasspath(buildpath);
                builder.setSourcepath(sourcepath.toArray(new File[0]));
                Jar bndJar = builder.build();
                this.expandJar(bndJar, this.classesDir);
            } else {
                logger.debug("No build");
            }
            this.reportErrorsAndWarnings(builder);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("bnd error: " + e.getMessage(), e);
        }
    }

    private File loadProperties(Builder builder) throws Exception {
        this.loadParentProjectProperties(builder, this.project);
        Xpp3Dom configuration = Optional.ofNullable(this.project.getBuildPlugins()).flatMap(this::getConfiguration).orElseGet(this::defaultConfiguration);
        return this.loadProjectProperties(builder, this.project, this.project, configuration);
    }

    private void loadParentProjectProperties(Builder builder, MavenProject currentProject) throws Exception {
        MavenProject parentProject = currentProject.getParent();
        if (parentProject == null) {
            return;
        }
        this.loadParentProjectProperties(builder, parentProject);
        Xpp3Dom configuration = Optional.ofNullable(parentProject.getBuildPlugins()).flatMap(this::getConfiguration).orElse(null);
        if (configuration != null) {
            this.loadProjectProperties(builder, parentProject, parentProject, configuration);
            return;
        }
        configuration = Optional.ofNullable(currentProject.getPluginManagement()).map(PluginContainer::getPlugins).flatMap(this::getConfiguration).orElseGet(this::defaultConfiguration);
        this.loadProjectProperties(builder, parentProject, currentProject, configuration);
    }

    private File loadProjectProperties(Builder builder, MavenProject bndProject, MavenProject pomProject, Xpp3Dom configuration) throws Exception {
        Xpp3Dom bndElement;
        File pomFile;
        File baseDir = bndProject.getBasedir();
        if (baseDir != null) {
            pomFile = bndProject.getFile();
            builder.updateModified(pomFile.lastModified(), "POM: " + pomFile);
            Xpp3Dom bndfileElement = configuration.getChild("bndfile");
            String bndFileName = bndfileElement != null ? bndfileElement.getValue() : "bnd.bnd";
            File bndFile = IO.getFile((File)baseDir, (String)bndFileName);
            if (bndFile.isFile()) {
                logger.debug("loading bnd properties from file: {}", (Object)bndFile);
                builder.setProperties(bndFile.getParentFile(), builder.loadProperties(bndFile));
                return bndFile;
            }
        }
        baseDir = pomProject.getBasedir();
        pomFile = pomProject.getFile();
        if (baseDir != null) {
            builder.updateModified(pomFile.lastModified(), "POM: " + pomFile);
        }
        if ((bndElement = configuration.getChild("bnd")) != null) {
            logger.debug("loading bnd properties from bnd element in pom: {}", (Object)pomProject);
            UTF8Properties properties = new UTF8Properties();
            properties.load(bndElement.getValue(), pomFile, (Reporter)builder);
            builder.setProperties(baseDir, (Properties)properties.replaceHere(baseDir));
        }
        return pomFile;
    }

    private Optional<Xpp3Dom> getConfiguration(List<Plugin> plugins) {
        return plugins.stream().filter(p -> Objects.equals(p, this.mojoExecution.getPlugin())).map(Plugin::getExecutions).flatMap(Collection::stream).filter(e -> Objects.equals(e.getId(), this.mojoExecution.getExecutionId())).findFirst().map(ConfigurationContainer::getConfiguration).map(Xpp3Dom.class::cast).map(Xpp3Dom::new);
    }

    private Xpp3Dom defaultConfiguration() {
        return new Xpp3Dom("configuration");
    }

    private void reportErrorsAndWarnings(Builder builder) throws MojoExecutionException {
        Collection<File> markedFiles = (HashSet)this.buildContext.getValue(MARKED_FILES);
        if (markedFiles == null) {
            this.buildContext.removeMessages(this.propertiesFile);
            markedFiles = builder.getIncluded();
        }
        if (markedFiles != null) {
            for (File file : markedFiles) {
                this.buildContext.removeMessages(file);
            }
        }
        markedFiles = new HashSet();
        List warnings = builder.getWarnings();
        for (String warning : warnings) {
            Report.Location location = builder.getLocation(warning);
            if (location == null) {
                location = new Report.Location();
                location.message = warning;
            }
            File f = location.file == null ? this.propertiesFile : new File(location.file);
            markedFiles.add(f);
            this.buildContext.addMessage(f, location.line, location.length, location.message, 1, null);
        }
        List list = builder.getErrors();
        for (String error : list) {
            Report.Location location = builder.getLocation(error);
            if (location == null) {
                location = new Report.Location();
                location.message = error;
            }
            File f = location.file == null ? this.propertiesFile : new File(location.file);
            markedFiles.add(f);
            this.buildContext.addMessage(f, location.line, location.length, location.message, 2, null);
        }
        this.buildContext.setValue(MARKED_FILES, markedFiles);
        if (!builder.isOk()) {
            if (list.size() == 1) {
                throw new MojoExecutionException((String)list.get(0));
            }
            throw new MojoExecutionException("Errors in bnd processing, see log for details.");
        }
    }

    private void expandJar(Jar jar, File dir) throws Exception {
        long lastModified = jar.lastModified();
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Bundle lastModified: %tF %<tT.%<tL", lastModified));
        }
        dir = dir.getAbsoluteFile();
        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        for (Map.Entry entry : jar.getResources().entrySet()) {
            FileResource fr;
            File outFile = IO.getFile((File)dir, (String)((String)entry.getKey()));
            aQute.bnd.osgi.Resource resource = (aQute.bnd.osgi.Resource)entry.getValue();
            if (resource instanceof FileResource && outFile.equals((fr = (FileResource)resource).getFile()) || outFile.exists() && outFile.lastModified() >= lastModified) continue;
            if (logger.isDebugEnabled()) {
                if (outFile.exists()) {
                    logger.debug(String.format("Updating lastModified: %tF %<tT.%<tL '%s'", outFile.lastModified(), outFile));
                } else {
                    logger.debug("Creating '{}'", (Object)outFile);
                }
            }
            Files.createDirectories(outFile.toPath().getParent(), new FileAttribute[0]);
            OutputStream out = this.buildContext.newFileOutputStream(outFile);
            Throwable throwable = null;
            try {
                IO.copy((InputStream)resource.openInputStream(), (OutputStream)out);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
        if (this.manifestOutOfDate() || this.manifestPath.lastModified() < lastModified) {
            if (logger.isDebugEnabled()) {
                if (!this.manifestOutOfDate()) {
                    logger.debug(String.format("Updating lastModified: %tF %<tT.%<tL '%s'", this.manifestPath.lastModified(), this.manifestPath));
                } else {
                    logger.debug("Creating '{}'", (Object)this.manifestPath);
                }
            }
            Files.createDirectories(this.manifestPath.toPath().getParent(), new FileAttribute[0]);
            try (OutputStream manifestOut = this.buildContext.newFileOutputStream(this.manifestPath);){
                jar.writeManifest(manifestOut);
            }
            this.buildContext.setValue(MANIFEST_LAST_MODIFIED, (Object)this.manifestPath.lastModified());
        }
    }

    private boolean manifestOutOfDate() {
        if (!this.manifestPath.isFile()) {
            return true;
        }
        long manifestLastModified = 0L;
        if (this.buildContext.getValue(MANIFEST_LAST_MODIFIED) != null) {
            manifestLastModified = (Long)this.buildContext.getValue(MANIFEST_LAST_MODIFIED);
        }
        return this.manifestPath.lastModified() != manifestLastModified;
    }

    private class BeanProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        BeanProperties() {
        }

        @Override
        public String getProperty(String key) {
            int i = key.indexOf(46);
            String name = i > 0 ? key.substring(0, i) : key;
            Object value = this.get(name);
            if (value != null && i > 0) {
                value = this.getField(value, key.substring(i + 1));
            }
            if (value == null) {
                return null;
            }
            return value.toString();
        }

        private Object getField(Object target, String key) {
            int i = key.indexOf(46);
            String fieldName = i > 0 ? key.substring(0, i) : key;
            String getterSuffix = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            Object value = null;
            try {
                Method getter;
                Class<?> targetClass = target.getClass();
                while (!Modifier.isPublic(targetClass.getModifiers())) {
                    targetClass = targetClass.getSuperclass();
                }
                try {
                    getter = targetClass.getMethod("get" + getterSuffix, new Class[0]);
                }
                catch (NoSuchMethodException nsme) {
                    getter = targetClass.getMethod("is" + getterSuffix, new Class[0]);
                }
                value = getter.invoke(target, new Object[0]);
            }
            catch (Exception e) {
                logger.debug("Could not find getter method for field: {}", (Object)fieldName, (Object)e);
            }
            if (value != null && i > 0) {
                value = this.getField(value, key.substring(i + 1));
            }
            return value;
        }
    }
}

