package aQute.bnd.make;

import java.io.*;
import java.util.regex.*;

import aQute.bnd.annotation.*;
import aQute.bnd.make.ComponentDef.Reference;
import aQute.bnd.service.*;
import aQute.lib.osgi.*;

public class AnnotationReader extends ClassDataCollector {
    StringBuilder       sb                     = new StringBuilder();
    String              method;
    String              methodDescriptor;
    String              className;
    Clazz               clazz;
    String              interfaces[];
    
    ComponentDef        def                    = new ComponentDef();

    final static String COMPONENT_ANNOTATION   = "L"
                                                       + Component.class
                                                               .getName()
                                                               .replace('.',
                                                                       '/')
                                                       + ";";
    final static String REFERENCE_ANNOTATION   = "L"
                                                       + aQute.bnd.annotation.Reference.class
                                                               .getName()
                                                               .replace('.',
                                                                       '/')
                                                       + ";";
    final static String UNREFERENCE_ANNOTATION = "L"
                                                       + Unreference.class
                                                               .getName()
                                                               .replace('.',
                                                                       '/')
                                                       + ";";
    final static String ACTIVATE_ANNOTATION    = "L"
                                                       + Activate.class
                                                               .getName()
                                                               .replace('.',
                                                                       '/')
                                                       + ";";
    final static String DEACTIVATE_ANNOTATION  = "L"
                                                       + Deactivate.class
                                                               .getName()
                                                               .replace('.',
                                                                       '/')
                                                       + ";";
    final static String MODIFIED_ANNOTATION    = "L"
                                                       + Modified.class
                                                               .getName()
                                                               .replace('.',
                                                                       '/')
                                                       + ";";

    
       
    
    
    public ComponentDef getComponent() throws Exception {
        clazz.parseClassFileWithCollector(this);
        if (def.name != null)
            return def;

        return null;
    }

    public static ComponentDef getComponentDef(Clazz clazz) throws Exception {
        AnnotationReader car = new AnnotationReader(clazz);
        return car.getComponent();
    }

    public static ComponentDef getComponentDef(File f) throws Exception {
        Resource r = new FileResource(f);
        Clazz c = new Clazz("", r);
        AnnotationReader car = new AnnotationReader(c);
        return car.getComponent();
    }

    AnnotationReader(Clazz clazz) {
        this.clazz = clazz;
    }

    public void annotation(Annotation annotation) {

        if (annotation.getName().equals(COMPONENT_ANNOTATION)) {
            def.name = annotation.get("name");
            def.factory = annotation.get("factory");
            def.enabled = annotation.get("enabled");
            def.immediate = annotation.get("immediate");

            String cp = (String) annotation.get("configurationPolicy");
            if (cp != null) {
                def.configurationPolicy = cp.toLowerCase();
            }

            if (def.name == null) {
                def.name = className;
            }
            def.implementation = className.replace('/', '.');

            Object[] provides = (Object[]) annotation.get("provides");
            if (provides == null) {
                def.provides = interfaces;
            } else {
                def.provides = new String[provides.length];
                for (int i = 0; provides != null && i < provides.length; i++)
                    def.provides[i] = descriptorToFQN(provides[i].toString());
            }
        } else if (annotation.getName().equals(ACTIVATE_ANNOTATION)) {
            def.activate = method;
        } else if (annotation.getName().equals(DEACTIVATE_ANNOTATION)) {
            def.deactivate = method;
        } else if (annotation.getName().equals(MODIFIED_ANNOTATION)) {
            def.modified = method;
        } else if (annotation.getName().equals(REFERENCE_ANNOTATION)) {
            ComponentDef.Reference ref = getReference(annotation, method);
            ref.multiple = (Boolean) annotation.get("multiple");
            ref.optional = (Boolean) annotation.get("optional");
            ref.dynamic = (Boolean) annotation.get("dynamic");

            Integer c = annotation.get("type");
            if (c != null) {
                switch (c.intValue()) {
                case 0:
                    break;
                case '?':
                    ref.multiple = false;
                    ref.optional = true;
                    ref.dynamic = true;
                    break;
                case '*':
                    ref.multiple = true;
                    ref.optional = true;
                    ref.dynamic = true;
                    break;
                case '+':
                    ref.multiple = true;
                    ref.optional = false;
                    ref.dynamic = true;
                    break;

                case '1':
                    ref.multiple = false;
                    ref.optional = false;
                    ref.dynamic = false;
                    break;
                case '~':
                    ref.multiple = false;
                    ref.optional = true;
                    ref.dynamic = false;
                    break;
                }
            }
            ref.target = (String) annotation.get("target");
            ref.bind = method;
            setService(ref, methodDescriptor);
        } else if (annotation.getName().equals(UNREFERENCE_ANNOTATION)) {
            ComponentDef.Reference ref = getReference(annotation, method);
            ref.unbind = method;
            setService(ref, methodDescriptor);
        }
    }

    /**
     * Skip L and ; and replace / for . in an object descriptor.
     * 
     * A string like Lcom/acme/Foo; becomes com.acme.Foo
     * 
     * @param string
     * @return
     */

    private String descriptorToFQN(String string) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < string.length() - 1; i++) {
            char c = string.charAt(i);
            if (c == '/')
                c = '.';
            sb.append(c);
        }
        return sb.toString();
    }

    static Pattern BINDDESCRIPTOR = Pattern.compile("\\(L(.*);\\)V");
    static Pattern BINDMETHOD     = Pattern
                                          .compile("(unset|set|bind|unbind)?(.)(.*)");

    private Reference getReference(Annotation annotation, String method) {
        String name = (String) annotation.get("name");
        if (name == null) {
            Matcher m = BINDMETHOD.matcher(method);
            if (m.matches()) {
                name = m.group(2).toLowerCase() + m.group(3);
            } else
                name = method;
        }
        return def.newReference(name);
    }

    void setService(ComponentDef.Reference ref, String descriptor) {
        Matcher m = BINDDESCRIPTOR.matcher(descriptor);
        if (m.matches()) {
            String s = m.group(1).replace('/', '.');
            if (ref.service == null)
                ref.service = s;
            else if (!ref.service.equals(s)) {
                throw new IllegalArgumentException(
                        "the bind and unbind method use different types for "
                                + ref.name);
            }
        }
    }

    @Override
    public void classBegin(int access, String name) {
        className = name;
    }

    @Override
    public void implementsInterfaces(String[] interfaces) {
        this.interfaces = interfaces;
    }

    @Override
    public void method(int access, String name, String descriptor) {
        this.method = name;
        this.methodDescriptor = descriptor;
    }

}
