/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.BaseMockServer;
import au.com.dius.pact.consumer.ConsumerPactRunnerKt;
import au.com.dius.pact.consumer.MessagePactTestRun;
import au.com.dius.pact.consumer.MockHttpServerKt;
import au.com.dius.pact.consumer.PactTestExecutionContext;
import au.com.dius.pact.consumer.PactTestRun;
import au.com.dius.pact.consumer.PactVerificationResult;
import au.com.dius.pact.consumer.model.MockProviderConfig;
import au.com.dius.pact.core.matchers.generators.ArrayContainsJsonGenerator;
import au.com.dius.pact.core.matchers.generators.DefaultResponseGenerator;
import au.com.dius.pact.core.model.BasePact;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.InvalidPactException;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.V4Interaction;
import au.com.dius.pact.core.model.generators.GeneratorTestMode;
import au.com.dius.pact.core.model.messaging.Message;
import au.com.dius.pact.core.model.messaging.MessagePact;
import au.com.dius.pact.core.model.v4.MessageContents;
import au.com.dius.pact.core.support.V4PactFeaturesException;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0002\u001a\u00020\u0003\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00040\n\u001a,\u0010\u000b\u001a\u00020\u0003\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0010\u001a\"\u0010\u0011\u001a\u00020\u0003\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "runConsumerTest", "Lau/com/dius/pact/consumer/PactVerificationResult;", "R", "pact", "Lau/com/dius/pact/core/model/BasePact;", "config", "Lau/com/dius/pact/consumer/model/MockProviderConfig;", "test", "Lau/com/dius/pact/consumer/PactTestRun;", "runMessageConsumerTest", "Lau/com/dius/pact/core/model/Pact;", "pactVersion", "Lau/com/dius/pact/core/model/PactSpecVersion;", "testFunc", "Lau/com/dius/pact/consumer/MessagePactTestRun;", "runV4MessageConsumerTest", "consumer"})
@SourceDebugExtension(value={"SMAP\nConsumerPactRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsumerPactRunner.kt\nau/com/dius/pact/consumer/ConsumerPactRunnerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1549#2:151\n1620#2,3:152\n1603#2,9:155\n1855#2:164\n1549#2:165\n1620#2,3:166\n1856#2:170\n1612#2:171\n1#3:169\n*S KotlinDebug\n*F\n+ 1 ConsumerPactRunner.kt\nau/com/dius/pact/consumer/ConsumerPactRunnerKt\n*L\n64#1:151\n64#1:152,3\n89#1:155,9\n89#1:164\n117#1:165\n117#1:166,3\n89#1:170\n89#1:171\n89#1:169\n*E\n"})
public final class ConsumerPactRunnerKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);

    @NotNull
    public static final <R> PactVerificationResult runConsumerTest(@NotNull BasePact pact, @NotNull MockProviderConfig config, @NotNull PactTestRun<R> test) {
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(test, (String)"test");
        List errors = pact.validateForVersion(config.getPactVersion());
        if (!((Collection)errors).isEmpty()) {
            return new PactVerificationResult.Error((Throwable)new V4PactFeaturesException("Pact specification V4 features can not be used with version " + config.getPactVersion() + " - " + CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)), new PactVerificationResult.Ok(null, 1, null));
        }
        if (!pact.isRequestResponsePact()) {
            throw new InvalidPactException("Expected an HTTP Request/Response Pact");
        }
        BaseMockServer server2 = MockHttpServerKt.mockServer(pact, config);
        return server2.runAndWritePact(pact, config.getPactVersion(), test);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <R> PactVerificationResult runMessageConsumerTest(@NotNull Pact pact, @NotNull PactSpecVersion pactVersion, @NotNull MessagePactTestRun<R> testFunc) {
        PactVerificationResult pactVerificationResult;
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)pactVersion, (String)"pactVersion");
        Intrinsics.checkNotNullParameter(testFunc, (String)"testFunc");
        logger.debug((Function0)new Function0<Object>(pact){
            final /* synthetic */ Pact $pact;
            {
                this.$pact = $pact;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Running message consumer test with " + this.$pact;
            }
        });
        List errors = pact.validateForVersion(pactVersion);
        if (!((Collection)errors).isEmpty()) {
            return new PactVerificationResult.Error((Throwable)new V4PactFeaturesException("Pact specification V4 features can not be used with version " + pactVersion + " - " + CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)), new PactVerificationResult.Ok(null, 1, null));
        }
        try {
            void $this$mapTo$iv$iv;
            PactTestExecutionContext context = new PactTestExecutionContext(null, 1, null);
            MessagePact messagePact2 = (MessagePact)pact.asMessagePact().expect((Function0)runMessageConsumerTest.messagePact.1.INSTANCE);
            Iterable $this$map$iv = messagePact2.getMessages();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Message message = (Message)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                V4Interaction.AsynchronousMessage asynchronousMessage = it.asAsynchronousMessage();
                Intrinsics.checkNotNull((Object)asynchronousMessage);
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ArrayContainsJsonGenerator", (Object)ArrayContainsJsonGenerator.INSTANCE)};
                MessageContents generated = DefaultResponseGenerator.INSTANCE.generateContents(asynchronousMessage.getContents(), MapsKt.mutableMapOf((Pair[])pairArray), GeneratorTestMode.Consumer, CollectionsKt.emptyList(), MapsKt.emptyMap(), true);
                collection.add(new Message(it.getDescription(), it.getProviderStates(), generated.getContents(), it.getMatchingRules(), it.getGenerators(), MapsKt.toMutableMap((Map)MapsKt.plus((Map)it.getMetadata(), (Map)generated.getMetadata())), it.getInteractionId()));
            }
            List messages = (List)destination$iv$iv;
            logger.debug((Function0)new Function0<Object>((List<Message>)messages){
                final /* synthetic */ List<Message> $messages;
                {
                    this.$messages = $messages;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Calling test function with generated messages: " + this.$messages;
                }
            });
            R result = testFunc.run(messages, context);
            pact.write(context.getPactFolder(), pactVersion).expect((Function0)runMessageConsumerTest.3.INSTANCE);
            pactVerificationResult = new PactVerificationResult.Ok(result);
        }
        catch (Throwable e) {
            logger.error(e, (Function0)runMessageConsumerTest.4.INSTANCE);
            pactVerificationResult = new PactVerificationResult.Error(e, new PactVerificationResult.Ok(null, 1, null));
        }
        return pactVerificationResult;
    }

    public static /* synthetic */ PactVerificationResult runMessageConsumerTest$default(Pact pact, PactSpecVersion pactSpecVersion, MessagePactTestRun messagePactTestRun, int n, Object object) {
        if ((n & 2) != 0) {
            pactSpecVersion = PactSpecVersion.V3;
        }
        return ConsumerPactRunnerKt.runMessageConsumerTest(pact, pactSpecVersion, messagePactTestRun);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <R> PactVerificationResult runV4MessageConsumerTest(@NotNull Pact pact, @NotNull MessagePactTestRun<R> testFunc) {
        PactVerificationResult pactVerificationResult;
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter(testFunc, (String)"testFunc");
        logger.debug((Function0)new Function0<Object>(pact){
            final /* synthetic */ Pact $pact;
            {
                this.$pact = $pact;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Running V4 message consumer test with " + this.$pact;
            }
        });
        try {
            void $this$mapNotNullTo$iv$iv;
            PactTestExecutionContext context = new PactTestExecutionContext(null, 1, null);
            Iterable $this$mapNotNull$iv = pact.getInteractions();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                V4Interaction v4Interaction;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Interaction message = (Interaction)element$iv$iv;
                boolean bl2 = false;
                Interaction interaction = message;
                if (interaction instanceof V4Interaction.AsynchronousMessage) {
                    var18_17 = new Pair[]{TuplesKt.to((Object)"ArrayContainsJsonGenerator", (Object)ArrayContainsJsonGenerator.INSTANCE)};
                    generated = DefaultResponseGenerator.INSTANCE.generateContents(((V4Interaction.AsynchronousMessage)message).getContents(), MapsKt.mutableMapOf((Pair[])var18_17), GeneratorTestMode.Consumer, CollectionsKt.emptyList(), MapsKt.emptyMap(), true);
                    v4Interaction = (V4Interaction)new V4Interaction.AsynchronousMessage(((V4Interaction.AsynchronousMessage)message).getKey(), message.getDescription(), generated, message.getInteractionId(), ((V4Interaction.AsynchronousMessage)message).getProviderStates(), message.getComments(), ((V4Interaction.AsynchronousMessage)message).getPending(), ((V4Interaction.AsynchronousMessage)message).getPluginConfiguration(), ((V4Interaction.AsynchronousMessage)message).getInteractionMarkup(), ((V4Interaction.AsynchronousMessage)message).getTransport());
                } else if (interaction instanceof V4Interaction.SynchronousMessages) {
                    void $this$mapTo$iv$iv;
                    var18_17 = new Pair[]{TuplesKt.to((Object)"ArrayContainsJsonGenerator", (Object)ArrayContainsJsonGenerator.INSTANCE)};
                    generated = DefaultResponseGenerator.INSTANCE.generateContents(((V4Interaction.SynchronousMessages)message).getRequest(), MapsKt.mutableMapOf((Pair[])var18_17), GeneratorTestMode.Consumer, CollectionsKt.emptyList(), MapsKt.emptyMap(), true);
                    Iterable $this$map$iv = ((V4Interaction.SynchronousMessages)message).getResponse();
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        MessageContents messageContents = (MessageContents)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl3 = false;
                        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ArrayContainsJsonGenerator", (Object)ArrayContainsJsonGenerator.INSTANCE)};
                        collection.add(DefaultResponseGenerator.INSTANCE.generateContents((MessageContents)it, MapsKt.mutableMapOf((Pair[])pairArray), GeneratorTestMode.Consumer, CollectionsKt.emptyList(), MapsKt.emptyMap(), true));
                    }
                    List generatedResponses = (List)destination$iv$iv2;
                    v4Interaction = (V4Interaction)new V4Interaction.SynchronousMessages(((V4Interaction.SynchronousMessages)message).getKey(), message.getDescription(), message.getInteractionId(), ((V4Interaction.SynchronousMessages)message).getProviderStates(), message.getComments(), ((V4Interaction.SynchronousMessages)message).getPending(), generated, CollectionsKt.toMutableList((Collection)generatedResponses), ((V4Interaction.SynchronousMessages)message).getPluginConfiguration(), ((V4Interaction.SynchronousMessages)message).getInteractionMarkup(), ((V4Interaction.SynchronousMessages)message).getTransport());
                } else {
                    v4Interaction = null;
                }
                if (v4Interaction == null) continue;
                V4Interaction it$iv$iv = v4Interaction;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List messages = (List)destination$iv$iv;
            logger.debug((Function0)new Function0<Object>((List<? extends V4Interaction>)messages){
                final /* synthetic */ List<V4Interaction> $messages;
                {
                    this.$messages = $messages;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Calling test function with generated messages: " + this.$messages;
                }
            });
            R result = testFunc.run(messages, context);
            pact.write(context.getPactFolder(), PactSpecVersion.V4).expect((Function0)runV4MessageConsumerTest.3.INSTANCE);
            pactVerificationResult = new PactVerificationResult.Ok(result);
        }
        catch (Throwable e) {
            logger.error(e, (Function0)runV4MessageConsumerTest.4.INSTANCE);
            pactVerificationResult = new PactVerificationResult.Error(e, new PactVerificationResult.Ok(null, 1, null));
        }
        return pactVerificationResult;
    }
}

