/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.InvalidMatcherException;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslJsonArray;
import au.com.dius.pact.consumer.dsl.PactDslJsonRootValue;
import au.com.dius.pact.core.matchers.UrlMatcherSupport;
import au.com.dius.pact.core.model.Feature;
import au.com.dius.pact.core.model.FeatureToggles;
import au.com.dius.pact.core.model.generators.Category;
import au.com.dius.pact.core.model.generators.DateGenerator;
import au.com.dius.pact.core.model.generators.DateTimeGenerator;
import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.generators.ProviderStateGenerator;
import au.com.dius.pact.core.model.generators.RandomDecimalGenerator;
import au.com.dius.pact.core.model.generators.RandomHexadecimalGenerator;
import au.com.dius.pact.core.model.generators.RandomIntGenerator;
import au.com.dius.pact.core.model.generators.RandomStringGenerator;
import au.com.dius.pact.core.model.generators.RegexGenerator;
import au.com.dius.pact.core.model.generators.TimeGenerator;
import au.com.dius.pact.core.model.generators.UuidGenerator;
import au.com.dius.pact.core.model.matchingrules.EqualsMatcher;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import au.com.dius.pact.core.model.matchingrules.MatchingRuleGroup;
import au.com.dius.pact.core.model.matchingrules.NumberTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.RuleLogic;
import au.com.dius.pact.core.model.matchingrules.TypeMatcher;
import au.com.dius.pact.core.model.matchingrules.ValuesMatcher;
import au.com.dius.pact.core.support.expressions.DataType;
import com.mifmif.common.regex.Generex;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.json.JSONObject;

public class PactDslJsonBody
extends DslPart {
    private static final String EXAMPLE = "Example \"";
    private final JSONObject body;

    public PactDslJsonBody() {
        super(".", "");
        this.body = new JSONObject();
    }

    public PactDslJsonBody(String rootPath, String rootName, DslPart parent) {
        super(parent, rootPath, rootName);
        this.body = new JSONObject();
    }

    public PactDslJsonBody(String rootPath, String rootName, DslPart parent, PactDslJsonBody body) {
        super(parent, rootPath, rootName);
        this.body = body.body;
        this.matchers = body.matchers.copyWithUpdatedMatcherRootPrefix(rootPath);
        this.generators = body.generators.copyWithUpdatedMatcherRootPrefix(rootPath);
    }

    public String toString() {
        return this.body.toString();
    }

    @Override
    protected void putObject(DslPart object) {
        for (String matcherName : object.matchers.getMatchingRules().keySet()) {
            this.matchers.setRules(matcherName, (MatchingRuleGroup)object.matchers.getMatchingRules().get(matcherName));
        }
        this.generators.addGenerators(object.generators);
        String elementBase = StringUtils.difference((String)this.rootPath, (String)object.rootPath);
        if (StringUtils.isNotEmpty((CharSequence)object.rootName)) {
            this.body.put(object.rootName, object.getBody());
        } else {
            String name = StringUtils.strip((String)elementBase, (String)".");
            Pattern p = Pattern.compile("\\['(.+)'\\]");
            Matcher matcher = p.matcher(name);
            if (matcher.matches()) {
                this.body.put(matcher.group(1), object.getBody());
            } else {
                this.body.put(name, object.getBody());
            }
        }
    }

    @Override
    protected void putArray(DslPart object) {
        for (String matcherName : object.matchers.getMatchingRules().keySet()) {
            this.matchers.setRules(matcherName, (MatchingRuleGroup)object.matchers.getMatchingRules().get(matcherName));
        }
        this.generators.addGenerators(object.generators);
        if (StringUtils.isNotEmpty((CharSequence)object.rootName)) {
            this.body.put(object.rootName, object.getBody());
        } else {
            this.body.put(StringUtils.difference((String)this.rootPath, (String)object.rootPath), object.getBody());
        }
    }

    @Override
    public Object getBody() {
        return this.body;
    }

    public PactDslJsonBody stringValue(String name, String value) {
        if (value == null) {
            this.body.put(name, JSONObject.NULL);
        } else {
            this.body.put(name, (Object)value);
        }
        return this;
    }

    public PactDslJsonBody numberValue(String name, Number value) {
        this.body.put(name, (Object)value);
        return this;
    }

    public PactDslJsonBody booleanValue(String name, Boolean value) {
        this.body.put(name, (Object)value);
        return this;
    }

    public PactDslJsonBody stringType(String name) {
        this.generators.addGenerator(Category.BODY, this.matcherKey(name), (Generator)new RandomStringGenerator(20));
        return this.stringType(name, "string");
    }

    public PactDslJsonBody stringType(String ... names) {
        for (String name : names) {
            this.stringType(name);
        }
        return this;
    }

    public PactDslJsonBody stringType(String name, String example) {
        this.body.put(name, (Object)example);
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)TypeMatcher.INSTANCE);
        return this;
    }

    private String matcherKey(String name) {
        String key = this.rootPath + name;
        if (StringUtils.containsAny((CharSequence)name, (CharSequence)"'[].@ \t\n")) {
            key = StringUtils.stripEnd((String)this.rootPath, (String)".") + "['" + name + "']";
        }
        return key;
    }

    public PactDslJsonBody numberType(String name) {
        this.generators.addGenerator(Category.BODY, this.matcherKey(name), (Generator)new RandomIntGenerator(0, Integer.MAX_VALUE));
        return this.numberType(name, 100);
    }

    public PactDslJsonBody numberType(String ... names) {
        for (String name : names) {
            this.numberType(name);
        }
        return this;
    }

    public PactDslJsonBody numberType(String name, Number number) {
        this.body.put(name, (Object)number);
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.NUMBER));
        return this;
    }

    public PactDslJsonBody integerType(String name) {
        this.generators.addGenerator(Category.BODY, this.matcherKey(name), (Generator)new RandomIntGenerator(0, Integer.MAX_VALUE));
        return this.integerType(name, 100);
    }

    public PactDslJsonBody integerType(String ... names) {
        for (String name : names) {
            this.integerType(name);
        }
        return this;
    }

    public PactDslJsonBody integerType(String name, Long number) {
        this.body.put(name, (Object)number);
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.INTEGER));
        return this;
    }

    public PactDslJsonBody integerType(String name, Integer number) {
        this.body.put(name, (Object)number);
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.INTEGER));
        return this;
    }

    public PactDslJsonBody decimalType(String name) {
        this.generators.addGenerator(Category.BODY, this.matcherKey(name), (Generator)new RandomDecimalGenerator(10));
        return this.decimalType(name, 100.0);
    }

    public PactDslJsonBody decimalType(String ... names) {
        for (String name : names) {
            this.decimalType(name);
        }
        return this;
    }

    public PactDslJsonBody decimalType(String name, BigDecimal number) {
        this.body.put(name, (Object)number);
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.DECIMAL));
        return this;
    }

    public PactDslJsonBody decimalType(String name, Double number) {
        this.body.put(name, (Object)number);
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.DECIMAL));
        return this;
    }

    public PactDslJsonBody booleanType(String name) {
        return this.booleanType(name, true);
    }

    public PactDslJsonBody booleanType(String ... names) {
        for (String name : names) {
            this.booleanType(name);
        }
        return this;
    }

    public PactDslJsonBody booleanType(String name, Boolean example) {
        this.body.put(name, (Object)example);
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)TypeMatcher.INSTANCE);
        return this;
    }

    public PactDslJsonBody stringMatcher(String name, String regex, String value) {
        if (!value.matches(regex)) {
            throw new InvalidMatcherException(EXAMPLE + value + "\" does not match regular expression \"" + regex + "\"");
        }
        this.body.put(name, (Object)value);
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.regexp(regex));
        return this;
    }

    public PactDslJsonBody stringMatcher(String name, String regex) {
        this.generators.addGenerator(Category.BODY, this.matcherKey(name), (Generator)new RegexGenerator(regex));
        this.stringMatcher(name, regex, new Generex(regex).random());
        return this;
    }

    public PactDslJsonBody timestamp() {
        return this.timestamp("timestamp");
    }

    @Deprecated
    public PactDslJsonBody timestamp(String name) {
        this.datetime(name);
        return this;
    }

    @Deprecated
    public PactDslJsonBody timestamp(String name, String format) {
        this.datetime(name, format);
        return this;
    }

    @Deprecated
    public PactDslJsonBody timestamp(String name, String format, Date example) {
        return this.datetime(name, format, example, TimeZone.getDefault());
    }

    @Deprecated
    public PactDslJsonBody timestamp(String name, String format, Date example, TimeZone timeZone) {
        this.datetime(name, format, example, timeZone);
        return this;
    }

    @Deprecated
    public PactDslJsonBody timestamp(String name, String format, Instant example) {
        return this.datetime(name, format, example, TimeZone.getDefault());
    }

    @Deprecated
    public PactDslJsonBody timestamp(String name, String format, Instant example, TimeZone timeZone) {
        this.datetime(name, format, example, timeZone);
        return this;
    }

    public PactDslJsonBody datetime(String name) {
        String pattern = DateFormatUtils.ISO_DATETIME_FORMAT.getPattern();
        this.generators.addGenerator(Category.BODY, this.matcherKey(name), (Generator)new DateTimeGenerator(pattern, null));
        this.body.put(name, (Object)DateFormatUtils.ISO_DATETIME_FORMAT.format(new Date(949323600000L)));
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchTimestamp(pattern));
        return this;
    }

    public PactDslJsonBody datetime(String name, String format) {
        this.generators.addGenerator(Category.BODY, this.matcherKey(name), (Generator)new DateTimeGenerator(format, null));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(ZoneId.systemDefault());
        this.body.put(name, (Object)formatter.format(new Date(949323600000L).toInstant()));
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchTimestamp(format));
        return this;
    }

    public PactDslJsonBody datetime(String name, String format, Date example) {
        return this.datetime(name, format, example, TimeZone.getDefault());
    }

    public PactDslJsonBody datetime(String name, String format, Date example, TimeZone timeZone) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(timeZone.toZoneId());
        this.body.put(name, (Object)formatter.format(example.toInstant()));
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchTimestamp(format));
        return this;
    }

    public PactDslJsonBody datetime(String name, String format, Instant example) {
        return this.datetime(name, format, example, TimeZone.getDefault());
    }

    public PactDslJsonBody datetime(String name, String format, Instant example, TimeZone timeZone) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(timeZone.toZoneId());
        this.body.put(name, (Object)formatter.format(example));
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchTimestamp(format));
        return this;
    }

    public PactDslJsonBody date() {
        return this.date("date");
    }

    public PactDslJsonBody date(String name) {
        String pattern = DateFormatUtils.ISO_DATE_FORMAT.getPattern();
        this.generators.addGenerator(Category.BODY, this.matcherKey(name), (Generator)new DateGenerator(pattern, null));
        this.body.put(name, (Object)DateFormatUtils.ISO_DATE_FORMAT.format(new Date(949323600000L)));
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchDate(pattern));
        return this;
    }

    public PactDslJsonBody date(String name, String format) {
        this.generators.addGenerator(Category.BODY, this.matcherKey(name), (Generator)new DateGenerator(format, null));
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put(name, (Object)instance.format(new Date(949323600000L)));
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchDate(format));
        return this;
    }

    public PactDslJsonBody date(String name, String format, Date example) {
        return this.date(name, format, example, TimeZone.getDefault());
    }

    public PactDslJsonBody date(String name, String format, Date example, TimeZone timeZone) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format, (TimeZone)timeZone);
        this.body.put(name, (Object)instance.format(example));
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchDate(format));
        return this;
    }

    public PactDslJsonBody time() {
        return this.time("time");
    }

    public PactDslJsonBody time(String name) {
        String pattern = DateFormatUtils.ISO_TIME_FORMAT.getPattern();
        this.generators.addGenerator(Category.BODY, this.matcherKey(name), (Generator)new TimeGenerator(pattern, null));
        this.body.put(name, (Object)DateFormatUtils.ISO_TIME_FORMAT.format(new Date(949323600000L)));
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchTime(pattern));
        return this;
    }

    public PactDslJsonBody time(String name, String format) {
        this.generators.addGenerator(Category.BODY, this.matcherKey(name), (Generator)new TimeGenerator(format, null));
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put(name, (Object)instance.format(new Date(949323600000L)));
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchTime(format));
        return this;
    }

    public PactDslJsonBody time(String name, String format, Date example) {
        return this.time(name, format, example, TimeZone.getDefault());
    }

    public PactDslJsonBody time(String name, String format, Date example, TimeZone timeZone) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format, (TimeZone)timeZone);
        this.body.put(name, (Object)instance.format(example));
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchTime(format));
        return this;
    }

    public PactDslJsonBody ipAddress(String name) {
        this.body.put(name, (Object)"127.0.0.1");
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.regexp("(\\d{1,3}\\.)+\\d{1,3}"));
        return this;
    }

    @Override
    public PactDslJsonBody object(String name) {
        String base = this.rootPath + name;
        if (StringUtils.containsAny((CharSequence)name, (CharSequence)"'[].@ \t\n")) {
            base = StringUtils.substringBeforeLast((String)this.rootPath, (String)".") + "['" + name + "']";
        }
        return new PactDslJsonBody(base + ".", "", this);
    }

    @Override
    public PactDslJsonBody object() {
        throw new UnsupportedOperationException("use the object(String name) form");
    }

    public PactDslJsonBody object(String name, DslPart value) {
        String base = this.rootPath + name;
        if (StringUtils.containsAny((CharSequence)name, (CharSequence)"'[].@ \t\n")) {
            base = StringUtils.substringBeforeLast((String)this.rootPath, (String)".") + "['" + name + "']";
        }
        if (value instanceof PactDslJsonBody) {
            PactDslJsonBody object = new PactDslJsonBody(base, "", this, (PactDslJsonBody)value);
            this.putObject(object);
        } else if (value instanceof PactDslJsonArray) {
            PactDslJsonArray object = new PactDslJsonArray(base, "", (DslPart)this, (PactDslJsonArray)value);
            this.putArray(object);
        }
        return this;
    }

    @Override
    public DslPart closeObject() {
        if (this.parent != null) {
            this.parent.putObject(this);
        } else {
            this.getMatchers().applyMatcherRootPrefix("$");
            this.getGenerators().applyRootPrefix("$");
        }
        this.closed = true;
        return this.parent;
    }

    @Override
    public DslPart close() {
        DslPart parentToReturn = this;
        if (!this.closed) {
            DslPart parent = this.closeObject();
            while (parent != null) {
                parentToReturn = parent;
                if (parent instanceof PactDslJsonArray) {
                    parent = parent.closeArray();
                    continue;
                }
                parent = parent.closeObject();
            }
        }
        return parentToReturn;
    }

    @Override
    public PactDslJsonArray array(String name) {
        return new PactDslJsonArray(this.matcherKey(name), name, this);
    }

    @Override
    public PactDslJsonArray array() {
        throw new UnsupportedOperationException("use the array(String name) form");
    }

    @Override
    public DslPart closeArray() {
        if (this.parent instanceof PactDslJsonArray) {
            this.closeObject();
            return this.parent.closeArray();
        }
        throw new UnsupportedOperationException("can't call closeArray on an Object");
    }

    @Override
    public PactDslJsonBody eachLike(String name) {
        return this.eachLike(name, 1);
    }

    @Override
    public PactDslJsonBody eachLike() {
        throw new UnsupportedOperationException("use the eachLike(String name) form");
    }

    @Override
    public PactDslJsonBody eachLike(String name, int numberExamples) {
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchMin(0));
        PactDslJsonArray parent = new PactDslJsonArray(this.matcherKey(name), "", (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonBody(".", ".", parent);
    }

    @Override
    public PactDslJsonBody eachLike(int numberExamples) {
        throw new UnsupportedOperationException("use the eachLike(String name, int numberExamples) form");
    }

    public PactDslJsonBody eachLike(String name, PactDslJsonRootValue value) {
        return this.eachLike(name, value, 1);
    }

    public PactDslJsonBody eachLike(String name, PactDslJsonRootValue value, int numberExamples) {
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchMin(0));
        PactDslJsonArray parent = new PactDslJsonArray(this.matcherKey(name), "", (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        parent.putObject(value);
        return (PactDslJsonBody)parent.closeArray();
    }

    @Override
    public PactDslJsonBody minArrayLike(String name, Integer size) {
        return this.minArrayLike(name, size, size);
    }

    @Override
    public PactDslJsonBody minArrayLike(Integer size) {
        throw new UnsupportedOperationException("use the minArrayLike(String name, Integer size) form");
    }

    @Override
    public PactDslJsonBody minArrayLike(String name, Integer size, int numberExamples) {
        if (numberExamples < size) {
            throw new IllegalArgumentException(String.format("Number of example %d is less than the minimum size of %d", numberExamples, size));
        }
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchMin(size));
        PactDslJsonArray parent = new PactDslJsonArray(this.matcherKey(name), "", (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonBody(".", "", parent);
    }

    @Override
    public PactDslJsonBody minArrayLike(Integer size, int numberExamples) {
        throw new UnsupportedOperationException("use the minArrayLike(String name, Integer size, int numberExamples) form");
    }

    public PactDslJsonBody minArrayLike(String name, Integer size, PactDslJsonRootValue value) {
        return this.minArrayLike(name, size, value, 2);
    }

    public PactDslJsonBody minArrayLike(String name, Integer size, PactDslJsonRootValue value, int numberExamples) {
        if (numberExamples < size) {
            throw new IllegalArgumentException(String.format("Number of example %d is less than the minimum size of %d", numberExamples, size));
        }
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchMin(size));
        PactDslJsonArray parent = new PactDslJsonArray(this.matcherKey(name), "", (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        parent.putObject(value);
        return (PactDslJsonBody)parent.closeArray();
    }

    @Override
    public PactDslJsonBody maxArrayLike(String name, Integer size) {
        return this.maxArrayLike(name, size, 1);
    }

    @Override
    public PactDslJsonBody maxArrayLike(Integer size) {
        throw new UnsupportedOperationException("use the maxArrayLike(String name, Integer size) form");
    }

    @Override
    public PactDslJsonBody maxArrayLike(String name, Integer size, int numberExamples) {
        if (numberExamples > size) {
            throw new IllegalArgumentException(String.format("Number of example %d is more than the maximum size of %d", numberExamples, size));
        }
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchMax(size));
        PactDslJsonArray parent = new PactDslJsonArray(this.matcherKey(name), "", (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonBody(".", "", parent);
    }

    @Override
    public PactDslJsonBody maxArrayLike(Integer size, int numberExamples) {
        throw new UnsupportedOperationException("use the maxArrayLike(String name, Integer size, int numberExamples) form");
    }

    public PactDslJsonBody maxArrayLike(String name, Integer size, PactDslJsonRootValue value) {
        return this.maxArrayLike(name, size, value, 1);
    }

    public PactDslJsonBody maxArrayLike(String name, Integer size, PactDslJsonRootValue value, int numberExamples) {
        if (numberExamples > size) {
            throw new IllegalArgumentException(String.format("Number of example %d is more than the maximum size of %d", numberExamples, size));
        }
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchMax(size));
        PactDslJsonArray parent = new PactDslJsonArray(this.matcherKey(name), "", (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        parent.putObject(value);
        return (PactDslJsonBody)parent.closeArray();
    }

    public PactDslJsonBody id() {
        return this.id("id");
    }

    public PactDslJsonBody id(String name) {
        this.generators.addGenerator(Category.BODY, this.matcherKey(name), (Generator)new RandomIntGenerator(0, Integer.MAX_VALUE));
        this.body.put(name, 1234567890L);
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)TypeMatcher.INSTANCE);
        return this;
    }

    public PactDslJsonBody id(String name, Long id) {
        this.body.put(name, (Object)id);
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)TypeMatcher.INSTANCE);
        return this;
    }

    public PactDslJsonBody hexValue(String name) {
        this.generators.addGenerator(Category.BODY, this.matcherKey(name), (Generator)new RandomHexadecimalGenerator(10));
        return this.hexValue(name, "1234a");
    }

    public PactDslJsonBody hexValue(String name, String hexValue) {
        if (!hexValue.matches("[0-9a-fA-F]+")) {
            throw new InvalidMatcherException(EXAMPLE + hexValue + "\" is not a hexadecimal value");
        }
        this.body.put(name, (Object)hexValue);
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.regexp("[0-9a-fA-F]+"));
        return this;
    }

    public PactDslJsonBody uuid(String name) {
        this.generators.addGenerator(Category.BODY, this.matcherKey(name), (Generator)UuidGenerator.INSTANCE);
        return this.uuid(name, "e2490de5-5bd3-43d5-b7c4-526e33f71304");
    }

    public PactDslJsonBody uuid(String name, UUID uuid) {
        return this.uuid(name, uuid.toString());
    }

    public PactDslJsonBody uuid(String name, String uuid) {
        if (!uuid.matches("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}")) {
            throw new InvalidMatcherException(EXAMPLE + uuid + "\" is not an UUID");
        }
        this.body.put(name, (Object)uuid);
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.regexp("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}"));
        return this;
    }

    public PactDslJsonBody nullValue(String fieldName) {
        this.body.put(fieldName, JSONObject.NULL);
        return this;
    }

    @Override
    public PactDslJsonArray eachArrayLike(String name) {
        return this.eachArrayLike(name, 1);
    }

    @Override
    public PactDslJsonArray eachArrayLike() {
        throw new UnsupportedOperationException("use the eachArrayLike(String name) form");
    }

    @Override
    public PactDslJsonArray eachArrayLike(String name, int numberExamples) {
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchMin(0));
        PactDslJsonArray parent = new PactDslJsonArray(this.matcherKey(name), name, (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonArray("", "", parent);
    }

    @Override
    public PactDslJsonArray eachArrayLike(int numberExamples) {
        throw new UnsupportedOperationException("use the eachArrayLike(String name, int numberExamples) form");
    }

    @Override
    public PactDslJsonArray eachArrayWithMaxLike(String name, Integer size) {
        return this.eachArrayWithMaxLike(name, 1, size);
    }

    @Override
    public PactDslJsonArray eachArrayWithMaxLike(Integer size) {
        throw new UnsupportedOperationException("use the eachArrayWithMaxLike(String name, Integer size) form");
    }

    @Override
    public PactDslJsonArray eachArrayWithMaxLike(String name, int numberExamples, Integer size) {
        if (numberExamples > size) {
            throw new IllegalArgumentException(String.format("Number of example %d is more than the maximum size of %d", numberExamples, size));
        }
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchMax(size));
        PactDslJsonArray parent = new PactDslJsonArray(this.matcherKey(name), name, (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonArray("", "", parent);
    }

    @Override
    public PactDslJsonArray eachArrayWithMaxLike(int numberExamples, Integer size) {
        throw new UnsupportedOperationException("use the eachArrayWithMaxLike(String name, int numberExamples, Integer size) form");
    }

    @Override
    public PactDslJsonArray eachArrayWithMinLike(String name, Integer size) {
        return this.eachArrayWithMinLike(name, size, size);
    }

    @Override
    public PactDslJsonArray eachArrayWithMinLike(Integer size) {
        throw new UnsupportedOperationException("use the eachArrayWithMinLike(String name, Integer size) form");
    }

    @Override
    public PactDslJsonArray eachArrayWithMinLike(String name, int numberExamples, Integer size) {
        if (numberExamples < size) {
            throw new IllegalArgumentException(String.format("Number of example %d is less than the minimum size of %d", numberExamples, size));
        }
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchMin(size));
        PactDslJsonArray parent = new PactDslJsonArray(this.matcherKey(name), name, (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonArray("", "", parent);
    }

    @Override
    public PactDslJsonArray eachArrayWithMinLike(int numberExamples, Integer size) {
        throw new UnsupportedOperationException("use the eachArrayWithMinLike(String name, int numberExamples, Integer size) form");
    }

    public PactDslJsonBody eachKeyMappedToAnArrayLike(String exampleKey) {
        if (FeatureToggles.isFeatureSet((Feature)Feature.UseMatchValuesMatcher)) {
            this.matchers.addRule(this.rootPath.endsWith(".") ? this.rootPath.substring(0, this.rootPath.length() - 1) : this.rootPath, (MatchingRule)ValuesMatcher.INSTANCE);
        } else {
            this.matchers.addRule(this.rootPath + "*", (MatchingRule)this.matchMin(0));
        }
        PactDslJsonArray parent = new PactDslJsonArray(this.rootPath + "*", exampleKey, (DslPart)this, true);
        return new PactDslJsonBody(".", "", parent);
    }

    public PactDslJsonBody eachKeyLike(String exampleKey) {
        if (FeatureToggles.isFeatureSet((Feature)Feature.UseMatchValuesMatcher)) {
            this.matchers.addRule(this.rootPath.endsWith(".") ? this.rootPath.substring(0, this.rootPath.length() - 1) : this.rootPath, (MatchingRule)ValuesMatcher.INSTANCE);
        } else {
            this.matchers.addRule(this.rootPath + "*", (MatchingRule)TypeMatcher.INSTANCE);
        }
        return new PactDslJsonBody(this.rootPath + "*.", exampleKey, this);
    }

    public PactDslJsonBody eachKeyLike(String exampleKey, PactDslJsonRootValue value) {
        this.body.put(exampleKey, value.getBody());
        if (FeatureToggles.isFeatureSet((Feature)Feature.UseMatchValuesMatcher)) {
            this.matchers.addRule(this.rootPath.endsWith(".") ? this.rootPath.substring(0, this.rootPath.length() - 1) : this.rootPath, (MatchingRule)ValuesMatcher.INSTANCE);
        }
        for (String matcherName : value.matchers.getMatchingRules().keySet()) {
            this.matchers.addRules(this.rootPath + "*" + matcherName, ((MatchingRuleGroup)value.matchers.getMatchingRules().get(matcherName)).getRules());
        }
        return this;
    }

    public PactDslJsonBody includesStr(String name, String value) {
        this.body.put(name, (Object)value);
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.includesMatcher(value));
        return this;
    }

    public PactDslJsonBody equalTo(String name, Object value) {
        this.body.put(name, value);
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)EqualsMatcher.INSTANCE);
        return this;
    }

    public PactDslJsonBody and(String name, Object value, MatchingRule ... rules) {
        if (value != null) {
            this.body.put(name, value);
        } else {
            this.body.put(name, JSONObject.NULL);
        }
        this.matchers.setRules(this.matcherKey(name), new MatchingRuleGroup(Arrays.asList(rules), RuleLogic.AND));
        return this;
    }

    public PactDslJsonBody or(String name, Object value, MatchingRule ... rules) {
        if (value != null) {
            this.body.put(name, value);
        } else {
            this.body.put(name, JSONObject.NULL);
        }
        this.matchers.setRules(this.matcherKey(name), new MatchingRuleGroup(Arrays.asList(rules), RuleLogic.OR));
        return this;
    }

    public PactDslJsonBody matchUrl(String name, String basePath, Object ... pathFragments) {
        UrlMatcherSupport urlMatcher = new UrlMatcherSupport(basePath, Arrays.asList(pathFragments));
        this.body.put(name, (Object)urlMatcher.getExampleValue());
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.regexp(urlMatcher.getRegexExpression()));
        return this;
    }

    @Override
    public PactDslJsonBody minMaxArrayLike(String name, Integer minSize, Integer maxSize) {
        return this.minMaxArrayLike(name, minSize, maxSize, minSize);
    }

    @Override
    public PactDslJsonBody minMaxArrayLike(Integer minSize, Integer maxSize) {
        throw new UnsupportedOperationException("use the minMaxArrayLike(String name, Integer minSize, Integer maxSize) form");
    }

    @Override
    public PactDslJsonBody minMaxArrayLike(String name, Integer minSize, Integer maxSize, int numberExamples) {
        this.validateMinAndMaxAndExamples(minSize, maxSize, numberExamples);
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchMinMax(minSize, maxSize));
        PactDslJsonArray parent = new PactDslJsonArray(this.matcherKey(name), "", (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonBody(".", "", parent);
    }

    private void validateMinAndMaxAndExamples(Integer minSize, Integer maxSize, int numberExamples) {
        if (minSize > maxSize) {
            throw new IllegalArgumentException(String.format("The minimum size %d is more than the maximum size of %d", minSize, maxSize));
        }
        if (numberExamples < minSize) {
            throw new IllegalArgumentException(String.format("Number of example %d is less than the minimum size of %d", numberExamples, minSize));
        }
        if (numberExamples > maxSize) {
            throw new IllegalArgumentException(String.format("Number of example %d is more than the maximum size of %d", numberExamples, maxSize));
        }
    }

    @Override
    public PactDslJsonBody minMaxArrayLike(Integer minSize, Integer maxSize, int numberExamples) {
        throw new UnsupportedOperationException("use the minMaxArrayLike(String name, Integer minSize, Integer maxSize, int numberExamples) form");
    }

    @Override
    public PactDslJsonArray eachArrayWithMinMaxLike(String name, Integer minSize, Integer maxSize) {
        return this.eachArrayWithMinMaxLike(name, minSize, minSize, maxSize);
    }

    @Override
    public PactDslJsonArray eachArrayWithMinMaxLike(Integer minSize, Integer maxSize) {
        throw new UnsupportedOperationException("use the eachArrayWithMinMaxLike(String name, Integer minSize, Integer maxSize) form");
    }

    @Override
    public PactDslJsonArray eachArrayWithMinMaxLike(String name, int numberExamples, Integer minSize, Integer maxSize) {
        this.validateMinAndMaxAndExamples(minSize, maxSize, numberExamples);
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchMinMax(minSize, maxSize));
        PactDslJsonArray parent = new PactDslJsonArray(this.matcherKey(name), name, (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonArray("", "", parent);
    }

    @Override
    public PactDslJsonArray eachArrayWithMinMaxLike(int numberExamples, Integer minSize, Integer maxSize) {
        throw new UnsupportedOperationException("use the eachArrayWithMinMaxLike(String name, int numberExamples, Integer minSize, Integer maxSize) form");
    }

    public PactDslJsonBody minMaxArrayLike(String name, Integer minSize, Integer maxSize, PactDslJsonRootValue value, int numberExamples) {
        this.validateMinAndMaxAndExamples(minSize, maxSize, numberExamples);
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchMinMax(minSize, maxSize));
        PactDslJsonArray parent = new PactDslJsonArray(this.matcherKey(name), "", (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        parent.putObject(value);
        return (PactDslJsonBody)parent.closeArray();
    }

    public PactDslJsonBody valueFromProviderState(String name, String expression, Object example) {
        this.generators.addGenerator(Category.BODY, this.matcherKey(name), (Generator)new ProviderStateGenerator(expression, DataType.from((Object)example)));
        this.body.put(name, example);
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)TypeMatcher.INSTANCE);
        return this;
    }

    public PactDslJsonBody dateExpression(String name, String expression) {
        return this.dateExpression(name, expression, DateFormatUtils.ISO_DATE_FORMAT.getPattern());
    }

    public PactDslJsonBody dateExpression(String name, String expression, String format) {
        this.generators.addGenerator(Category.BODY, this.matcherKey(name), (Generator)new DateGenerator(format, expression));
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put(name, (Object)instance.format(new Date(949323600000L)));
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchDate(format));
        return this;
    }

    public PactDslJsonBody timeExpression(String name, String expression) {
        return this.timeExpression(name, expression, DateFormatUtils.ISO_TIME_NO_T_FORMAT.getPattern());
    }

    public PactDslJsonBody timeExpression(String name, String expression, String format) {
        this.generators.addGenerator(Category.BODY, this.matcherKey(name), (Generator)new TimeGenerator(format, expression));
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put(name, (Object)instance.format(new Date(949323600000L)));
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchTime(format));
        return this;
    }

    public PactDslJsonBody datetimeExpression(String name, String expression) {
        return this.datetimeExpression(name, expression, DateFormatUtils.ISO_DATETIME_FORMAT.getPattern());
    }

    public PactDslJsonBody datetimeExpression(String name, String expression, String format) {
        this.generators.addGenerator(Category.BODY, this.matcherKey(name), (Generator)new DateTimeGenerator(format, expression));
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put(name, (Object)instance.format(new Date(949323600000L)));
        this.matchers.addRule(this.matcherKey(name), (MatchingRule)this.matchTimestamp(format));
        return this;
    }
}

