/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.xml.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.ws.jaxme.xs.xml.XsEEnumeration;
import org.apache.ws.jaxme.xs.xml.XsEFractionDigits;
import org.apache.ws.jaxme.xs.xml.XsELength;
import org.apache.ws.jaxme.xs.xml.XsEMaxExclusive;
import org.apache.ws.jaxme.xs.xml.XsEMaxInclusive;
import org.apache.ws.jaxme.xs.xml.XsEMaxLength;
import org.apache.ws.jaxme.xs.xml.XsEMinExclusive;
import org.apache.ws.jaxme.xs.xml.XsEMinInclusive;
import org.apache.ws.jaxme.xs.xml.XsEMinLength;
import org.apache.ws.jaxme.xs.xml.XsEPattern;
import org.apache.ws.jaxme.xs.xml.XsETotalDigits;
import org.apache.ws.jaxme.xs.xml.XsEWhiteSpace;
import org.apache.ws.jaxme.xs.xml.XsGSimpleRestrictionModel;
import org.apache.ws.jaxme.xs.xml.XsObject;
import org.apache.ws.jaxme.xs.xml.XsTFacetBase;
import org.apache.ws.jaxme.xs.xml.XsTLocalSimpleType;

public class XsGSimpleRestrictionModelImpl
implements XsGSimpleRestrictionModel {
    private final XsObject owner;
    private XsTLocalSimpleType simpleType;
    private List facets;

    protected XsGSimpleRestrictionModelImpl(XsObject pOwner) {
        this.owner = pOwner;
    }

    public XsTLocalSimpleType createSimpleType() {
        if (this.simpleType != null) {
            throw new IllegalStateException("Multiple 'simpleType' childs are forbidden.");
        }
        if (this.facets != null && this.facets.size() > 0) {
            throw new IllegalStateException("The 'simpleType' child element must precede the '" + ((XsTFacetBase)this.facets.get(0)).getFacetName() + "' child element.");
        }
        this.simpleType = this.owner.getObjectFactory().newXsTLocalSimpleType(this.owner);
        return this.simpleType;
    }

    public XsTLocalSimpleType getSimpleType() {
        return this.simpleType;
    }

    protected XsTFacetBase getFacetByName(String pName) {
        if (this.facets != null) {
            for (int i = 0; i < this.facets.size(); ++i) {
                XsTFacetBase facet = (XsTFacetBase)this.facets.get(i);
                if (!pName.equals(facet.getFacetName())) continue;
                return facet;
            }
        }
        return null;
    }

    protected void addFacet(XsTFacetBase pFacet) {
        if (this.facets == null) {
            this.facets = new ArrayList();
        }
        this.facets.add(pFacet);
    }

    protected void addUniqueFacet(XsTFacetBase pFacet) {
        if (this.getFacetByName(pFacet.getFacetName()) != null) {
            throw new IllegalStateException("Multiple '" + pFacet.getFacetName() + "' childs are forbidden.");
        }
        this.addFacet(pFacet);
    }

    public XsEMinExclusive createMinExclusive() {
        XsEMinExclusive minExclusive = this.owner.getObjectFactory().newXsEMinExclusive(this.owner);
        this.addUniqueFacet(minExclusive);
        return minExclusive;
    }

    public XsEMinExclusive getMinExclusive() {
        return (XsEMinExclusive)this.getFacetByName("minExclusive");
    }

    public XsEMinInclusive createMinInclusive() {
        XsEMinInclusive minInclusive = this.owner.getObjectFactory().newXsEMinInclusive(this.owner);
        this.addUniqueFacet(minInclusive);
        return minInclusive;
    }

    public XsEMinInclusive getMinInclusive() {
        return (XsEMinInclusive)this.getFacetByName("minInclusive");
    }

    public XsEMaxExclusive createMaxExclusive() {
        XsEMaxExclusive maxExclusive = this.owner.getObjectFactory().newXsEMaxExclusive(this.owner);
        this.addUniqueFacet(maxExclusive);
        return maxExclusive;
    }

    public XsEMaxExclusive getMaxExclusive() {
        return (XsEMaxExclusive)this.getFacetByName("maxExclusive");
    }

    public XsEMaxInclusive createMaxInclusive() {
        XsEMaxInclusive maxInclusive = this.owner.getObjectFactory().newXsEMaxInclusive(this.owner);
        this.addUniqueFacet(maxInclusive);
        return maxInclusive;
    }

    public XsEMaxInclusive getMaxInclusive() {
        return (XsEMaxInclusive)this.getFacetByName("maxInclusive");
    }

    public XsETotalDigits createTotalDigits() {
        XsETotalDigits totalDigits = this.owner.getObjectFactory().newXsETotalDigits(this.owner);
        this.addUniqueFacet(totalDigits);
        return totalDigits;
    }

    public XsETotalDigits getTotalDigits() {
        return (XsETotalDigits)this.getFacetByName("totalDigits");
    }

    public XsEFractionDigits createFractionDigits() {
        XsEFractionDigits fractionDigits = this.owner.getObjectFactory().newXsEFractionDigits(this.owner);
        this.addUniqueFacet(fractionDigits);
        return fractionDigits;
    }

    public XsEFractionDigits getFractionDigits() {
        return (XsEFractionDigits)this.getFacetByName("fractionDigits");
    }

    public XsELength createLength() {
        XsELength length = this.owner.getObjectFactory().newXsELength(this.owner);
        this.addUniqueFacet(length);
        return length;
    }

    public XsELength getLength() {
        return (XsELength)this.getFacetByName("length");
    }

    public XsEMinLength createMinLength() {
        XsEMinLength minLength = this.owner.getObjectFactory().newXsEMinLength(this.owner);
        this.addUniqueFacet(minLength);
        return minLength;
    }

    public XsEMinLength getMinLength() {
        return (XsEMinLength)this.getFacetByName("minLength");
    }

    public XsEMaxLength createMaxLength() {
        XsEMaxLength maxLength = this.owner.getObjectFactory().newXsEMaxLength(this.owner);
        this.addUniqueFacet(maxLength);
        return maxLength;
    }

    public XsEMaxLength getMaxLength() {
        return (XsEMaxLength)this.getFacetByName("maxLength");
    }

    public XsEWhiteSpace createWhiteSpace() {
        XsEWhiteSpace whiteSpace = this.owner.getObjectFactory().newXsEWhiteSpace(this.owner);
        this.addUniqueFacet(whiteSpace);
        return whiteSpace;
    }

    public XsEWhiteSpace getWhiteSpace() {
        return (XsEWhiteSpace)this.getFacetByName("whiteSpace");
    }

    public XsEPattern createPattern() {
        XsEPattern pattern = this.owner.getObjectFactory().newXsEPattern(this.owner);
        this.addFacet(pattern);
        return pattern;
    }

    public XsEPattern[] getPatterns() {
        if (this.facets == null) {
            return new XsEPattern[0];
        }
        ArrayList<XsTFacetBase> result = new ArrayList<XsTFacetBase>();
        for (int i = 0; i < this.facets.size(); ++i) {
            XsTFacetBase facet = (XsTFacetBase)this.facets.get(i);
            if (!"pattern".equals(facet.getFacetName())) continue;
            result.add(facet);
        }
        return result.toArray(new XsEPattern[result.size()]);
    }

    public XsEEnumeration createEnumeration() {
        XsEEnumeration enumeration = this.owner.getObjectFactory().newXsEEnumeration(this.owner);
        this.addFacet(enumeration);
        return enumeration;
    }

    public XsEEnumeration[] getEnumerations() {
        if (this.facets == null) {
            return new XsEEnumeration[0];
        }
        ArrayList<XsTFacetBase> result = new ArrayList<XsTFacetBase>();
        for (int i = 0; i < this.facets.size(); ++i) {
            XsTFacetBase facet = (XsTFacetBase)this.facets.get(i);
            if (!"enumeration".equals(facet.getFacetName())) continue;
            result.add(facet);
        }
        return result.toArray(new XsEEnumeration[result.size()]);
    }

    public boolean hasFacets() {
        return this.facets != null && this.facets.size() > 0;
    }

    public XsTFacetBase[] getFacets() {
        if (this.facets == null) {
            return new XsEEnumeration[0];
        }
        return this.facets.toArray(new XsTFacetBase[this.facets.size()]);
    }
}

