/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.xml;

import java.util.StringTokenizer;

public class XsBlockSet {
    boolean extensionAllowed;
    boolean restrictionAllowed;
    boolean substitutionAllowed;
    static /* synthetic */ Class class$org$apache$ws$jaxme$xs$xml$XsBlockSet;

    public boolean isExtensionAllowed() {
        return this.extensionAllowed;
    }

    public void setExtensionAllowed(boolean pExtensionAllowed) {
        this.extensionAllowed = pExtensionAllowed;
    }

    public boolean isRestrictionAllowed() {
        return this.restrictionAllowed;
    }

    public void setRestrictionAllowed(boolean pRestrictionAllowed) {
        this.restrictionAllowed = pRestrictionAllowed;
    }

    public boolean isSubstitutionAllowed() {
        return this.substitutionAllowed;
    }

    public void setSubstitutionAllowed(boolean pSubstitutionAllowed) {
        this.substitutionAllowed = pSubstitutionAllowed;
    }

    public static XsBlockSet valueOf(String pValue) {
        return new XsBlockSet(pValue);
    }

    public XsBlockSet(String pValue) {
        if ("#all".equals(pValue)) {
            this.setExtensionAllowed(true);
            this.setRestrictionAllowed(true);
            this.setSubstitutionAllowed(true);
        } else {
            StringTokenizer st = new StringTokenizer(pValue, " ");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if ("extension".equals(s)) {
                    this.setExtensionAllowed(true);
                    continue;
                }
                if ("restriction".equals(s)) {
                    this.setRestrictionAllowed(true);
                    continue;
                }
                if ("substitution".equals(s)) {
                    this.setSubstitutionAllowed(true);
                    continue;
                }
                throw new IllegalArgumentException("Invalid block set value: " + pValue + "; the token " + s + " did not resolve to either of 'extension', 'restriction', or 'substitution'.");
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.extensionAllowed) {
            sb.append("extension");
        }
        if (this.restrictionAllowed) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("restriction");
        }
        if (this.substitutionAllowed) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("substitution");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(class$org$apache$ws$jaxme$xs$xml$XsBlockSet == null ? (class$org$apache$ws$jaxme$xs$xml$XsBlockSet = XsBlockSet.class$("org.apache.ws.jaxme.xs.xml.XsBlockSet")) : class$org$apache$ws$jaxme$xs$xml$XsBlockSet).equals(o.getClass())) {
            return false;
        }
        XsBlockSet bs = (XsBlockSet)o;
        return bs.extensionAllowed == this.extensionAllowed && bs.restrictionAllowed == this.restrictionAllowed && bs.substitutionAllowed == this.substitutionAllowed;
    }

    public int hashCode() {
        int result = 0;
        if (this.extensionAllowed) {
            ++result;
        }
        if (this.restrictionAllowed) {
            result += 2;
        }
        if (this.substitutionAllowed) {
            result += 4;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

