/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.impl;

import org.apache.ws.jaxme.xs.XSEnumeration;
import org.apache.ws.jaxme.xs.XSSimpleType;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.impl.XSSimpleTypeImpl;
import org.apache.ws.jaxme.xs.xml.XsEEnumeration;
import org.apache.ws.jaxme.xs.xml.XsEPattern;
import org.apache.ws.jaxme.xs.xml.XsGSimpleRestrictionModel;
import org.xml.sax.SAXException;

public abstract class XSSimpleTypeRestrictionImpl
extends XSSimpleTypeImpl {
    private final XSSimpleType baseType;
    private final XSType restrictedType;
    private final XsGSimpleRestrictionModel restriction;
    private final XSEnumeration[] enumerations;

    protected XSSimpleTypeRestrictionImpl(XSType pParent, XSType pRestrictedType, XsGSimpleRestrictionModel pRestriction) throws SAXException {
        this.restrictedType = pRestrictedType;
        this.baseType = pRestrictedType.getSimpleType();
        this.restriction = pRestriction;
        XsEEnumeration[] enums = this.restriction.getEnumerations();
        if (enums.length == 0) {
            this.enumerations = this.getBaseType().getEnumerations();
        } else {
            this.enumerations = new XSEnumeration[enums.length];
            for (int i = 0; i < enums.length; ++i) {
                this.enumerations[i] = pParent.getXSSchema().getXSObjectFactory().newXSEnumeration(pParent, enums[i]);
            }
        }
    }

    protected XSSimpleType getBaseType() {
        return this.baseType;
    }

    public boolean isRestriction() {
        return true;
    }

    public XSType getRestrictedType() {
        return this.restrictedType;
    }

    protected XsGSimpleRestrictionModel getRestriction() {
        return this.restriction;
    }

    public String[][] getPattern() {
        XsEPattern[] patterns = this.restriction.getPatterns();
        String[][] base = this.getBaseType().getPattern();
        if (patterns.length == 0) {
            return base;
        }
        String[][] result = new String[base.length + 1][];
        for (int i = 0; i < base.length; ++i) {
            result[i + 1] = base[i];
        }
        String[] thisStepsPatterns = new String[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            thisStepsPatterns[i] = patterns[i].getValue();
        }
        result[0] = thisStepsPatterns;
        return result;
    }

    public XSEnumeration[] getEnumerations() {
        return this.enumerations;
    }
}

