/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.common;

import ai.timefold.solver.constraint.streams.common.InnerConstraintFactory;
import ai.timefold.solver.constraint.streams.common.RetrievalSemantics;
import ai.timefold.solver.core.api.domain.constraintweight.ConstraintConfiguration;
import ai.timefold.solver.core.api.domain.constraintweight.ConstraintConfigurationProvider;
import ai.timefold.solver.core.api.domain.constraintweight.ConstraintWeight;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.api.score.stream.ConstraintStream;
import ai.timefold.solver.core.impl.domain.constraintweight.descriptor.ConstraintConfigurationDescriptor;
import ai.timefold.solver.core.impl.domain.constraintweight.descriptor.ConstraintWeightDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import java.util.Objects;
import java.util.function.Function;

public abstract class AbstractConstraintStream<Solution_>
implements ConstraintStream {
    private final RetrievalSemantics retrievalSemantics;

    protected AbstractConstraintStream(RetrievalSemantics retrievalSemantics) {
        this.retrievalSemantics = Objects.requireNonNull(retrievalSemantics);
    }

    public RetrievalSemantics getRetrievalSemantics() {
        return this.retrievalSemantics;
    }

    protected Function<Solution_, Score<?>> buildConstraintWeightExtractor(ConstraintRef constraintRef) {
        SolutionDescriptor solutionDescriptor = this.getConstraintFactory().getSolutionDescriptor();
        ConstraintConfigurationDescriptor configurationDescriptor = solutionDescriptor.getConstraintConfigurationDescriptor();
        if (configurationDescriptor == null) {
            throw new IllegalStateException("The constraint (" + constraintRef + ") does not hard-code a constraint weight and there is no @" + ConstraintConfigurationProvider.class.getSimpleName() + " on the solution class (" + solutionDescriptor.getSolutionClass() + ").\nMaybe add a @" + ConstraintConfiguration.class.getSimpleName() + " class or use " + ConstraintStream.class.getSimpleName() + ".penalize()/reward() instead of penalizeConfigurable()/rewardConfigurable.");
        }
        ConstraintWeightDescriptor weightDescriptor = configurationDescriptor.findConstraintWeightDescriptor(constraintRef);
        if (weightDescriptor == null) {
            throw new IllegalStateException("The constraint (" + constraintRef + ") does not hard-code a constraint weight and there is no such @" + ConstraintWeight.class.getSimpleName() + " on the constraintConfigurationClass (" + configurationDescriptor.getConstraintConfigurationClass() + ").\nMaybe there is a typo in the constraintPackage or constraintName of one of the @" + ConstraintWeight.class.getSimpleName() + " members.\nMaybe add a @" + ConstraintWeight.class.getSimpleName() + " member for it.");
        }
        return weightDescriptor.createExtractor();
    }

    protected Function<Solution_, Score<?>> buildConstraintWeightExtractor(ConstraintRef constraintRef, Score<?> constraintWeight) {
        this.getConstraintFactory().getSolutionDescriptor().validateConstraintWeight(constraintRef, constraintWeight);
        return solution -> constraintWeight;
    }

    public abstract InnerConstraintFactory<Solution_, ?> getConstraintFactory();

    protected abstract <JustificationMapping_> JustificationMapping_ getDefaultJustificationMapping();

    protected abstract <IndictedObjectsMapping_> IndictedObjectsMapping_ getDefaultIndictedObjectsMapping();
}

