/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.uni;

import ai.timefold.solver.constraint.streams.bavet.common.AbstractMapNode;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.UniTuple;
import java.util.Objects;
import java.util.function.Function;

final class MapUniToUniNode<A, NewA>
extends AbstractMapNode<UniTuple<A>, UniTuple<NewA>> {
    private final Function<A, NewA> mappingFunction;

    MapUniToUniNode(int mapStoreIndex, Function<A, NewA> mappingFunction, TupleLifecycle<UniTuple<NewA>> nextNodesTupleLifecycle, int outputStoreSize) {
        super(mapStoreIndex, nextNodesTupleLifecycle, outputStoreSize);
        this.mappingFunction = Objects.requireNonNull(mappingFunction);
    }

    @Override
    protected UniTuple<NewA> map(UniTuple<A> tuple) {
        Object factA = tuple.factA;
        return new UniTuple<NewA>(this.mappingFunction.apply(factA), this.outputStoreSize);
    }

    @Override
    protected void remap(UniTuple<A> inTuple, UniTuple<NewA> outTuple) {
        Object factA = inTuple.factA;
        NewA newA = this.mappingFunction.apply(factA);
        outTuple.factA = newA;
    }
}

