/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.uni;

import ai.timefold.solver.constraint.streams.bavet.common.AbstractMapNode;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.QuadTuple;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.UniTuple;
import java.util.Objects;
import java.util.function.Function;

final class MapUniToQuadNode<A, NewA, NewB, NewC, NewD>
extends AbstractMapNode<UniTuple<A>, QuadTuple<NewA, NewB, NewC, NewD>> {
    private final Function<A, NewA> mappingFunctionA;
    private final Function<A, NewB> mappingFunctionB;
    private final Function<A, NewC> mappingFunctionC;
    private final Function<A, NewD> mappingFunctionD;

    MapUniToQuadNode(int mapStoreIndex, Function<A, NewA> mappingFunctionA, Function<A, NewB> mappingFunctionB, Function<A, NewC> mappingFunctionC, Function<A, NewD> mappingFunctionD, TupleLifecycle<QuadTuple<NewA, NewB, NewC, NewD>> nextNodesTupleLifecycle, int outputStoreSize) {
        super(mapStoreIndex, nextNodesTupleLifecycle, outputStoreSize);
        this.mappingFunctionA = Objects.requireNonNull(mappingFunctionA);
        this.mappingFunctionB = Objects.requireNonNull(mappingFunctionB);
        this.mappingFunctionC = Objects.requireNonNull(mappingFunctionC);
        this.mappingFunctionD = Objects.requireNonNull(mappingFunctionD);
    }

    @Override
    protected QuadTuple<NewA, NewB, NewC, NewD> map(UniTuple<A> tuple) {
        Object factA = tuple.factA;
        return new QuadTuple<NewA, NewB, NewC, NewD>(this.mappingFunctionA.apply(factA), this.mappingFunctionB.apply(factA), this.mappingFunctionC.apply(factA), this.mappingFunctionD.apply(factA), this.outputStoreSize);
    }

    @Override
    protected void remap(UniTuple<A> inTuple, QuadTuple<NewA, NewB, NewC, NewD> outTuple) {
        Object factA = inTuple.factA;
        NewA newA = this.mappingFunctionA.apply(factA);
        NewB newB = this.mappingFunctionB.apply(factA);
        NewC newC = this.mappingFunctionC.apply(factA);
        NewD newD = this.mappingFunctionD.apply(factA);
        outTuple.factA = newA;
        outTuple.factB = newB;
        outTuple.factC = newC;
        outTuple.factD = newD;
    }
}

