/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.tri;

import ai.timefold.solver.constraint.streams.bavet.common.AbstractMapNode;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.QuadTuple;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TriTuple;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.api.function.TriFunction;
import java.util.Objects;

final class MapTriToQuadNode<A, B, C, NewA, NewB, NewC, NewD>
extends AbstractMapNode<TriTuple<A, B, C>, QuadTuple<NewA, NewB, NewC, NewD>> {
    private final TriFunction<A, B, C, NewA> mappingFunctionA;
    private final TriFunction<A, B, C, NewB> mappingFunctionB;
    private final TriFunction<A, B, C, NewC> mappingFunctionC;
    private final TriFunction<A, B, C, NewD> mappingFunctionD;

    MapTriToQuadNode(int mapStoreIndex, TriFunction<A, B, C, NewA> mappingFunctionA, TriFunction<A, B, C, NewB> mappingFunctionB, TriFunction<A, B, C, NewC> mappingFunctionC, TriFunction<A, B, C, NewD> mappingFunctionD, TupleLifecycle<QuadTuple<NewA, NewB, NewC, NewD>> nextNodesTupleLifecycle, int outputStoreSize) {
        super(mapStoreIndex, nextNodesTupleLifecycle, outputStoreSize);
        this.mappingFunctionA = Objects.requireNonNull(mappingFunctionA);
        this.mappingFunctionB = Objects.requireNonNull(mappingFunctionB);
        this.mappingFunctionC = Objects.requireNonNull(mappingFunctionC);
        this.mappingFunctionD = Objects.requireNonNull(mappingFunctionD);
    }

    @Override
    protected QuadTuple<NewA, NewB, NewC, NewD> map(TriTuple<A, B, C> tuple) {
        Object factA = tuple.factA;
        Object factB = tuple.factB;
        Object factC = tuple.factC;
        return new QuadTuple<Object, Object, Object, Object>(this.mappingFunctionA.apply(factA, factB, factC), this.mappingFunctionB.apply(factA, factB, factC), this.mappingFunctionC.apply(factA, factB, factC), this.mappingFunctionD.apply(factA, factB, factC), this.outputStoreSize);
    }

    @Override
    protected void remap(TriTuple<A, B, C> inTuple, QuadTuple<NewA, NewB, NewC, NewD> outTuple) {
        Object factA = inTuple.factA;
        Object factB = inTuple.factB;
        Object factC = inTuple.factC;
        Object newA = this.mappingFunctionA.apply(factA, factB, factC);
        Object newB = this.mappingFunctionB.apply(factA, factB, factC);
        Object newC = this.mappingFunctionC.apply(factA, factB, factC);
        Object newD = this.mappingFunctionD.apply(factA, factB, factC);
        outTuple.factA = newA;
        outTuple.factB = newB;
        outTuple.factC = newC;
        outTuple.factD = newD;
    }
}

