/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.common.index;

import ai.timefold.solver.constraint.streams.bavet.common.index.IndexProperties;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

final class IndexerKey {
    private final IndexProperties indexProperties;
    private final int fromInclusive;
    private final int toExclusive;

    public IndexerKey(IndexProperties indexProperties, int fromInclusive, int toExclusive) {
        this.indexProperties = indexProperties;
        this.fromInclusive = fromInclusive;
        this.toExclusive = toExclusive;
    }

    public int hashCode() {
        if (this.indexProperties == null) {
            return 0;
        }
        int result = 1;
        for (int i = this.fromInclusive; i < this.toExclusive; ++i) {
            Object element = this.indexProperties.toKey(i);
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexerKey)) {
            return false;
        }
        IndexerKey other = (IndexerKey)o;
        for (int i = this.fromInclusive; i < this.toExclusive; ++i) {
            Object b;
            Object a = this.indexProperties.toKey(i);
            if (Objects.equals(a, b = other.indexProperties.toKey(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "IndexerKey " + IntStream.range(this.fromInclusive, this.toExclusive).mapToObj(this.indexProperties::toKey).map(Object::toString).collect(Collectors.joining(",", "[", "]"));
    }
}

