/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.common.index;

import ai.timefold.solver.constraint.streams.bavet.common.index.IndexProperties;
import ai.timefold.solver.constraint.streams.bavet.common.index.Indexer;
import ai.timefold.solver.core.impl.score.stream.JoinerType;
import ai.timefold.solver.core.impl.util.ElementAwareListEntry;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class ComparisonIndexer<T, Key_ extends Comparable<Key_>>
implements Indexer<T> {
    private final int indexKeyPosition;
    private final Supplier<Indexer<T>> downstreamIndexerSupplier;
    private final Comparator<Key_> keyComparator;
    private final boolean hasOrEquals;
    private final NavigableMap<Key_, Indexer<T>> comparisonMap;

    public ComparisonIndexer(JoinerType comparisonJoinerType, Supplier<Indexer<T>> downstreamIndexerSupplier) {
        this(comparisonJoinerType, 0, downstreamIndexerSupplier);
    }

    public ComparisonIndexer(JoinerType comparisonJoinerType, int indexKeyPosition, Supplier<Indexer<T>> downstreamIndexerSupplier) {
        this.indexKeyPosition = indexKeyPosition;
        this.downstreamIndexerSupplier = Objects.requireNonNull(downstreamIndexerSupplier);
        this.keyComparator = comparisonJoinerType == JoinerType.GREATER_THAN || comparisonJoinerType == JoinerType.GREATER_THAN_OR_EQUAL ? KeyComparator.INSTANCE.reversed() : KeyComparator.INSTANCE;
        this.hasOrEquals = comparisonJoinerType == JoinerType.GREATER_THAN_OR_EQUAL || comparisonJoinerType == JoinerType.LESS_THAN_OR_EQUAL;
        this.comparisonMap = new TreeMap<Key_, Indexer<T>>(this.keyComparator);
    }

    @Override
    public ElementAwareListEntry<T> put(IndexProperties indexProperties, T tuple) {
        Comparable indexKey = (Comparable)indexProperties.toKey(this.indexKeyPosition);
        Indexer<T> downstreamIndexer = (Indexer<T>)this.comparisonMap.get(indexKey);
        if (downstreamIndexer == null) {
            downstreamIndexer = this.downstreamIndexerSupplier.get();
            this.comparisonMap.put(indexKey, downstreamIndexer);
        }
        return downstreamIndexer.put(indexProperties, tuple);
    }

    @Override
    public void remove(IndexProperties indexProperties, ElementAwareListEntry<T> entry) {
        Comparable indexKey = (Comparable)indexProperties.toKey(this.indexKeyPosition);
        Indexer<T> downstreamIndexer = this.getDownstreamIndexer(indexProperties, indexKey, entry);
        downstreamIndexer.remove(indexProperties, entry);
        if (downstreamIndexer.isEmpty()) {
            this.comparisonMap.remove(indexKey);
        }
    }

    private Indexer<T> getDownstreamIndexer(IndexProperties indexProperties, Key_ indexerKey, ElementAwareListEntry<T> entry) {
        Indexer downstreamIndexer = (Indexer)this.comparisonMap.get(indexerKey);
        if (downstreamIndexer == null) {
            throw new IllegalStateException("Impossible state: the tuple (" + entry.getElement() + ") with indexProperties (" + indexProperties + ") doesn't exist in the indexer " + this + ".");
        }
        return downstreamIndexer;
    }

    @Override
    public int size(IndexProperties indexProperties) {
        Map.Entry entry;
        int comparison;
        int mapSize = this.comparisonMap.size();
        if (mapSize == 0) {
            return 0;
        }
        Comparable indexKey = (Comparable)indexProperties.toKey(this.indexKeyPosition);
        if (mapSize == 1) {
            Map.Entry<Key_, Indexer<T>> entry2 = this.comparisonMap.firstEntry();
            int comparison2 = this.keyComparator.compare((Comparable)entry2.getKey(), indexKey);
            if (!(comparison2 < 0 || comparison2 <= 0 && this.hasOrEquals)) {
                return 0;
            }
            return entry2.getValue().size(indexProperties);
        }
        int size = 0;
        Iterator iterator = this.comparisonMap.entrySet().iterator();
        while (iterator.hasNext() && ((comparison = this.keyComparator.compare((Comparable)(entry = iterator.next()).getKey(), indexKey)) < 0 || comparison <= 0 && this.hasOrEquals)) {
            size += ((Indexer)entry.getValue()).size(indexProperties);
        }
        return size;
    }

    @Override
    public void forEach(IndexProperties indexProperties, Consumer<T> tupleConsumer) {
        int size = this.comparisonMap.size();
        if (size == 0) {
            return;
        }
        Comparable indexKey = (Comparable)indexProperties.toKey(this.indexKeyPosition);
        if (size == 1) {
            Map.Entry<Key_, Indexer<T>> entry = this.comparisonMap.firstEntry();
            this.visitEntry(indexProperties, tupleConsumer, indexKey, entry);
        } else {
            for (Map.Entry entry : this.comparisonMap.entrySet()) {
                boolean boundaryReached = this.visitEntry(indexProperties, tupleConsumer, indexKey, entry);
                if (!boundaryReached) continue;
                return;
            }
        }
    }

    private boolean visitEntry(IndexProperties indexProperties, Consumer<T> tupleConsumer, Key_ indexKey, Map.Entry<Key_, Indexer<T>> entry) {
        int comparison = this.keyComparator.compare((Comparable)entry.getKey(), indexKey);
        if (!(comparison < 0 || comparison <= 0 && this.hasOrEquals)) {
            return true;
        }
        entry.getValue().forEach(indexProperties, tupleConsumer);
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.comparisonMap.isEmpty();
    }

    public String toString() {
        return "size = " + this.comparisonMap.size();
    }

    private static final class KeyComparator<Key_ extends Comparable<Key_>>
    implements Comparator<Key_> {
        private static final Comparator INSTANCE = new KeyComparator();

        private KeyComparator() {
        }

        @Override
        public int compare(Key_ o1, Key_ o2) {
            if (o1 == o2) {
                return 0;
            }
            return o1.compareTo(o2);
        }
    }
}

