/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.common;

import ai.timefold.solver.constraint.streams.bavet.common.AbstractPropagationMetadataCarrier;
import ai.timefold.solver.constraint.streams.bavet.common.PropagationQueue;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleState;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.Consumer;

final class DynamicPropagationQueue<Tuple_ extends AbstractTuple, Carrier_ extends AbstractPropagationMetadataCarrier<Tuple_>>
implements PropagationQueue<Carrier_> {
    private final Consumer<Carrier_> preprocessor;
    private final List<Carrier_> dirtyList;
    private final BitSet retractQueue;
    private final BitSet insertQueue;
    private final Consumer<Tuple_> retractPropagator;
    private final Consumer<Tuple_> updatePropagator;
    private final Consumer<Tuple_> insertPropagator;

    private DynamicPropagationQueue(TupleLifecycle<Tuple_> nextNodesTupleLifecycle, Consumer<Carrier_> preprocessor, int size) {
        this.preprocessor = preprocessor;
        this.dirtyList = new ArrayList<Carrier_>(size);
        this.retractQueue = new BitSet(size);
        this.insertQueue = new BitSet(size);
        this.retractPropagator = nextNodesTupleLifecycle::retract;
        this.updatePropagator = nextNodesTupleLifecycle::update;
        this.insertPropagator = nextNodesTupleLifecycle::insert;
    }

    public DynamicPropagationQueue(TupleLifecycle<Tuple_> nextNodesTupleLifecycle) {
        this(nextNodesTupleLifecycle, null);
    }

    public DynamicPropagationQueue(TupleLifecycle<Tuple_> nextNodesTupleLifecycle, Consumer<Carrier_> preprocessor) {
        this(nextNodesTupleLifecycle, preprocessor, 1000);
    }

    @Override
    public void insert(Carrier_ carrier) {
        int positionInDirtyList = ((AbstractPropagationMetadataCarrier)carrier).positionInDirtyList;
        if (positionInDirtyList < 0) {
            this.makeDirty(carrier, this.insertQueue);
        } else {
            switch (((AbstractPropagationMetadataCarrier)carrier).getState()) {
                case UPDATING: {
                    this.insertQueue.set(positionInDirtyList);
                    break;
                }
                case ABORTING: 
                case DYING: {
                    this.retractQueue.clear(positionInDirtyList);
                    this.insertQueue.set(positionInDirtyList);
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible state: Cannot insert (" + carrier + "), already inserting.");
                }
            }
        }
        ((AbstractPropagationMetadataCarrier)carrier).setState(TupleState.CREATING);
    }

    private void makeDirty(Carrier_ carrier, BitSet queue) {
        this.dirtyList.add(carrier);
        int position = this.dirtyList.size() - 1;
        queue.set(position);
        ((AbstractPropagationMetadataCarrier)carrier).positionInDirtyList = position;
    }

    @Override
    public void update(Carrier_ carrier) {
        int positionInDirtyList = ((AbstractPropagationMetadataCarrier)carrier).positionInDirtyList;
        if (positionInDirtyList < 0) {
            this.dirtyList.add(carrier);
            ((AbstractPropagationMetadataCarrier)carrier).positionInDirtyList = this.dirtyList.size() - 1;
        } else {
            switch (((AbstractPropagationMetadataCarrier)carrier).getState()) {
                case CREATING: {
                    this.insertQueue.clear(positionInDirtyList);
                    break;
                }
                case ABORTING: 
                case DYING: {
                    this.retractQueue.clear(positionInDirtyList);
                    break;
                }
            }
        }
        ((AbstractPropagationMetadataCarrier)carrier).setState(TupleState.UPDATING);
    }

    @Override
    public void retract(Carrier_ carrier, TupleState state) {
        if (state.isActive() || state == TupleState.DEAD) {
            throw new IllegalArgumentException("Impossible state: The state (" + state + ") is not a valid retract state.");
        }
        int positionInDirtyList = ((AbstractPropagationMetadataCarrier)carrier).positionInDirtyList;
        if (positionInDirtyList < 0) {
            this.makeDirty(carrier, this.retractQueue);
        } else {
            switch (((AbstractPropagationMetadataCarrier)carrier).getState()) {
                case CREATING: {
                    this.insertQueue.clear(positionInDirtyList);
                    this.retractQueue.set(positionInDirtyList);
                    break;
                }
                case UPDATING: {
                    this.retractQueue.set(positionInDirtyList);
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible state: Cannot retract (" + carrier + "), already retracting.");
                }
            }
        }
        ((AbstractPropagationMetadataCarrier)carrier).setState(state);
    }

    @Override
    public void propagateRetracts() {
        if (this.retractQueue.isEmpty()) {
            return;
        }
        int i = this.retractQueue.nextSetBit(0);
        while (i != -1) {
            AbstractPropagationMetadataCarrier carrier = (AbstractPropagationMetadataCarrier)this.dirtyList.get(i);
            TupleState state = carrier.getState();
            switch (state) {
                case DYING: {
                    DynamicPropagationQueue.propagate(carrier, this.retractPropagator, TupleState.DEAD);
                    break;
                }
                case ABORTING: {
                    DynamicPropagationQueue.clean(carrier, TupleState.DEAD);
                }
            }
            i = this.retractQueue.nextSetBit(i + 1);
        }
    }

    private static <Tuple_ extends AbstractTuple, Carrier_ extends AbstractPropagationMetadataCarrier<Tuple_>> void propagate(Carrier_ carrier, Consumer<Tuple_> propagator, TupleState tupleState) {
        DynamicPropagationQueue.clean(carrier, tupleState);
        propagator.accept(carrier.getTuple());
    }

    private static void clean(AbstractPropagationMetadataCarrier<?> carrier, TupleState tupleState) {
        carrier.setState(tupleState);
        carrier.positionInDirtyList = -1;
    }

    @Override
    public void propagateUpdates() {
        BitSet insertAndRetractQueue = DynamicPropagationQueue.buildInsertAndRetractQueue(this.insertQueue, this.retractQueue);
        if (insertAndRetractQueue == null) {
            for (AbstractPropagationMetadataCarrier carrier : this.dirtyList) {
                this.propagateInsertOrUpdate(carrier, this.updatePropagator);
            }
        } else {
            int dirtyListSize = this.dirtyList.size();
            int i = insertAndRetractQueue.nextClearBit(0);
            while (i != -1 && i < dirtyListSize) {
                this.propagateInsertOrUpdate((AbstractPropagationMetadataCarrier)this.dirtyList.get(i), this.updatePropagator);
                i = insertAndRetractQueue.nextClearBit(i + 1);
            }
        }
    }

    private static BitSet buildInsertAndRetractQueue(BitSet insertQueue, BitSet retractQueue) {
        boolean noInserts = insertQueue.isEmpty();
        boolean noRetracts = retractQueue.isEmpty();
        if (noInserts && noRetracts) {
            return null;
        }
        if (noInserts) {
            return retractQueue;
        }
        if (noRetracts) {
            return insertQueue;
        }
        BitSet updateQueue = new BitSet();
        updateQueue.or(insertQueue);
        updateQueue.or(retractQueue);
        return updateQueue;
    }

    @Override
    public void propagateInserts() {
        if (!this.insertQueue.isEmpty()) {
            int i = this.insertQueue.nextSetBit(0);
            while (i != -1) {
                this.propagateInsertOrUpdate((AbstractPropagationMetadataCarrier)this.dirtyList.get(i), this.insertPropagator);
                i = this.insertQueue.nextSetBit(i + 1);
            }
            this.insertQueue.clear();
        }
        this.retractQueue.clear();
        this.dirtyList.clear();
    }

    private void propagateInsertOrUpdate(Carrier_ carrier, Consumer<Tuple_> propagator) {
        if (this.preprocessor != null) {
            this.preprocessor.accept(carrier);
        }
        DynamicPropagationQueue.propagate(carrier, propagator, TupleState.OK);
    }
}

