/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.common;

import ai.timefold.solver.constraint.streams.bavet.common.AbstractNode;
import ai.timefold.solver.constraint.streams.bavet.common.Propagator;
import ai.timefold.solver.constraint.streams.bavet.common.StaticPropagationQueue;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleState;

public abstract class AbstractMapNode<InTuple_ extends AbstractTuple, OutTuple_ extends AbstractTuple>
extends AbstractNode
implements TupleLifecycle<InTuple_> {
    private final int inputStoreIndex;
    protected final int outputStoreSize;
    private final StaticPropagationQueue<OutTuple_> propagationQueue;

    protected AbstractMapNode(int inputStoreIndex, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle, int outputStoreSize) {
        this.inputStoreIndex = inputStoreIndex;
        this.outputStoreSize = outputStoreSize;
        this.propagationQueue = new StaticPropagationQueue<OutTuple_>(nextNodesTupleLifecycle);
    }

    @Override
    public final void insert(InTuple_ tuple) {
        if (((AbstractTuple)tuple).getStore(this.inputStoreIndex) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + tuple + ") was already added in the tupleStore.");
        }
        OutTuple_ outTuple = this.map(tuple);
        ((AbstractTuple)tuple).setStore(this.inputStoreIndex, outTuple);
        this.propagationQueue.insert(outTuple);
    }

    protected abstract OutTuple_ map(InTuple_ var1);

    @Override
    public final void update(InTuple_ tuple) {
        AbstractTuple outTuple = (AbstractTuple)((AbstractTuple)tuple).getStore(this.inputStoreIndex);
        if (outTuple == null) {
            this.insert(tuple);
            return;
        }
        this.remap(tuple, outTuple);
        TupleState previousState = outTuple.state;
        if (previousState == TupleState.CREATING || previousState == TupleState.UPDATING) {
            return;
        }
        this.propagationQueue.update((OutTuple_)outTuple);
    }

    protected abstract void remap(InTuple_ var1, OutTuple_ var2);

    @Override
    public final void retract(InTuple_ tuple) {
        AbstractTuple outTuple = (AbstractTuple)((AbstractTuple)tuple).removeStore(this.inputStoreIndex);
        if (outTuple == null) {
            return;
        }
        this.propagationQueue.retract((OutTuple_)outTuple, outTuple.state == TupleState.CREATING ? TupleState.ABORTING : TupleState.DYING);
    }

    @Override
    public Propagator getPropagator() {
        return this.propagationQueue;
    }
}

