/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.common;

import ai.timefold.solver.constraint.streams.bavet.common.AbstractIfExistsNode;
import ai.timefold.solver.constraint.streams.bavet.common.ExistsCounter;
import ai.timefold.solver.constraint.streams.bavet.common.index.IndexProperties;
import ai.timefold.solver.constraint.streams.bavet.common.index.Indexer;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.LeftTupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.RightTupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.util.ElementAwareList;
import ai.timefold.solver.core.impl.util.ElementAwareListEntry;
import java.util.function.Function;

public abstract class AbstractIndexedIfExistsNode<LeftTuple_ extends AbstractTuple, Right_>
extends AbstractIfExistsNode<LeftTuple_, Right_>
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final Function<Right_, IndexProperties> mappingRight;
    private final int inputStoreIndexLeftProperties;
    private final int inputStoreIndexLeftCounterEntry;
    private final int inputStoreIndexRightProperties;
    private final int inputStoreIndexRightEntry;
    private final Indexer<ExistsCounter<LeftTuple_>> indexerLeft;
    private final Indexer<UniTuple<Right_>> indexerRight;

    protected AbstractIndexedIfExistsNode(boolean shouldExist, Function<Right_, IndexProperties> mappingRight, int inputStoreIndexLeftProperties, int inputStoreIndexLeftCounterEntry, int inputStoreIndexLeftTrackerList, int inputStoreIndexRightProperties, int inputStoreIndexRightEntry, int inputStoreIndexRightTrackerList, TupleLifecycle<LeftTuple_> nextNodesTupleLifecycle, Indexer<ExistsCounter<LeftTuple_>> indexerLeft, Indexer<UniTuple<Right_>> indexerRight, boolean isFiltering) {
        super(shouldExist, inputStoreIndexLeftTrackerList, inputStoreIndexRightTrackerList, nextNodesTupleLifecycle, isFiltering);
        this.mappingRight = mappingRight;
        this.inputStoreIndexLeftProperties = inputStoreIndexLeftProperties;
        this.inputStoreIndexLeftCounterEntry = inputStoreIndexLeftCounterEntry;
        this.inputStoreIndexRightProperties = inputStoreIndexRightProperties;
        this.inputStoreIndexRightEntry = inputStoreIndexRightEntry;
        this.indexerLeft = indexerLeft;
        this.indexerRight = indexerRight;
    }

    @Override
    public final void insertLeft(LeftTuple_ leftTuple) {
        if (((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftProperties) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + leftTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.createIndexProperties(leftTuple);
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftProperties, indexProperties);
        ExistsCounter<LeftTuple_> counter = new ExistsCounter<LeftTuple_>(leftTuple);
        ElementAwareListEntry<ExistsCounter<LeftTuple_>> counterEntry = this.indexerLeft.put(indexProperties, counter);
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftCounterEntry, counterEntry);
        if (!this.isFiltering) {
            counter.countRight = this.indexerRight.size(indexProperties);
        } else {
            ElementAwareList leftTrackerList = new ElementAwareList();
            this.indexerRight.forEach(indexProperties, rightTuple -> this.updateCounterFromLeft(leftTuple, rightTuple, counter, leftTrackerList));
            ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftTrackerList, leftTrackerList);
        }
        this.initCounterLeft(counter);
    }

    @Override
    public final void updateLeft(LeftTuple_ leftTuple) {
        IndexProperties oldIndexProperties = (IndexProperties)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftProperties);
        if (oldIndexProperties == null) {
            this.insertLeft(leftTuple);
            return;
        }
        IndexProperties newIndexProperties = this.createIndexProperties(leftTuple);
        ElementAwareListEntry<ExistsCounter> counterEntry = (ElementAwareListEntry<ExistsCounter>)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftCounterEntry);
        ExistsCounter counter = (ExistsCounter)counterEntry.getElement();
        if (oldIndexProperties.equals(newIndexProperties)) {
            if (!this.isFiltering) {
                this.updateUnchangedCounterLeft(counter);
            } else {
                ElementAwareList leftTrackerList = (ElementAwareList)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftTrackerList);
                leftTrackerList.forEach(AbstractIfExistsNode.FilteringTracker::remove);
                counter.countRight = 0;
                this.indexerRight.forEach(oldIndexProperties, rightTuple -> this.updateCounterFromLeft(leftTuple, rightTuple, counter, leftTrackerList));
                this.updateCounterLeft(counter);
            }
        } else {
            this.updateIndexerLeft(oldIndexProperties, counterEntry, leftTuple);
            counter.countRight = 0;
            ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftProperties, newIndexProperties);
            counterEntry = this.indexerLeft.put(newIndexProperties, counter);
            ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftCounterEntry, counterEntry);
            if (!this.isFiltering) {
                counter.countRight = this.indexerRight.size(newIndexProperties);
            } else {
                ElementAwareList leftTrackerList = new ElementAwareList();
                this.indexerRight.forEach(newIndexProperties, rightTuple -> this.updateCounterFromLeft(leftTuple, rightTuple, counter, leftTrackerList));
                ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftTrackerList, leftTrackerList);
            }
            this.updateCounterLeft(counter);
        }
    }

    @Override
    public final void retractLeft(LeftTuple_ leftTuple) {
        IndexProperties indexProperties = (IndexProperties)((AbstractTuple)leftTuple).removeStore(this.inputStoreIndexLeftProperties);
        if (indexProperties == null) {
            return;
        }
        ElementAwareListEntry counterEntry = (ElementAwareListEntry)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftCounterEntry);
        ExistsCounter counter = (ExistsCounter)counterEntry.getElement();
        this.updateIndexerLeft(indexProperties, counterEntry, leftTuple);
        this.killCounterLeft(counter);
    }

    private void updateIndexerLeft(IndexProperties indexProperties, ElementAwareListEntry<ExistsCounter<LeftTuple_>> counterEntry, LeftTuple_ leftTuple) {
        this.indexerLeft.remove(indexProperties, counterEntry);
        if (this.isFiltering) {
            ElementAwareList leftTrackerList = (ElementAwareList)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftTrackerList);
            leftTrackerList.forEach(AbstractIfExistsNode.FilteringTracker::remove);
        }
    }

    @Override
    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.getStore(this.inputStoreIndexRightProperties) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + rightTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.mappingRight.apply(rightTuple.factA);
        rightTuple.setStore(this.inputStoreIndexRightProperties, indexProperties);
        ElementAwareListEntry<UniTuple<Right_>> rightEntry = this.indexerRight.put(indexProperties, rightTuple);
        rightTuple.setStore(this.inputStoreIndexRightEntry, rightEntry);
        if (!this.isFiltering) {
            this.indexerLeft.forEach(indexProperties, this::incrementCounterRight);
        } else {
            ElementAwareList rightTrackerList = new ElementAwareList();
            this.indexerLeft.forEach(indexProperties, counter -> this.updateCounterFromRight(rightTuple, counter, rightTrackerList));
            rightTuple.setStore(this.inputStoreIndexRightTrackerList, rightTrackerList);
        }
    }

    @Override
    public final void updateRight(UniTuple<Right_> rightTuple) {
        IndexProperties oldIndexProperties = (IndexProperties)rightTuple.getStore(this.inputStoreIndexRightProperties);
        if (oldIndexProperties == null) {
            this.insertRight(rightTuple);
            return;
        }
        IndexProperties newIndexProperties = this.mappingRight.apply(rightTuple.factA);
        if (oldIndexProperties.equals(newIndexProperties)) {
            if (this.isFiltering) {
                ElementAwareList rightTrackerList = this.updateRightTrackerList(rightTuple);
                this.indexerLeft.forEach(oldIndexProperties, counter -> this.updateCounterFromRight(rightTuple, counter, rightTrackerList));
            }
        } else {
            ElementAwareListEntry<UniTuple<Right_>> rightEntry = (ElementAwareListEntry<UniTuple<Right_>>)rightTuple.getStore(this.inputStoreIndexRightEntry);
            this.indexerRight.remove(oldIndexProperties, rightEntry);
            if (!this.isFiltering) {
                this.indexerLeft.forEach(oldIndexProperties, this::decrementCounterRight);
            } else {
                this.updateRightTrackerList(rightTuple);
            }
            rightTuple.setStore(this.inputStoreIndexRightProperties, newIndexProperties);
            rightEntry = this.indexerRight.put(newIndexProperties, rightTuple);
            rightTuple.setStore(this.inputStoreIndexRightEntry, rightEntry);
            if (!this.isFiltering) {
                this.indexerLeft.forEach(newIndexProperties, this::incrementCounterRight);
            } else {
                ElementAwareList rightTrackerList = new ElementAwareList();
                this.indexerLeft.forEach(newIndexProperties, counter -> this.updateCounterFromRight(rightTuple, counter, rightTrackerList));
                rightTuple.setStore(this.inputStoreIndexRightTrackerList, rightTrackerList);
            }
        }
    }

    @Override
    public final void retractRight(UniTuple<Right_> rightTuple) {
        IndexProperties indexProperties = (IndexProperties)rightTuple.removeStore(this.inputStoreIndexRightProperties);
        if (indexProperties == null) {
            return;
        }
        ElementAwareListEntry rightEntry = (ElementAwareListEntry)rightTuple.removeStore(this.inputStoreIndexRightEntry);
        this.indexerRight.remove(indexProperties, rightEntry);
        if (!this.isFiltering) {
            this.indexerLeft.forEach(indexProperties, this::decrementCounterRight);
        } else {
            this.updateRightTrackerList(rightTuple);
        }
    }

    protected abstract IndexProperties createIndexProperties(LeftTuple_ var1);
}

