/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.common;

import ai.timefold.solver.constraint.streams.bavet.common.AbstractNode;
import ai.timefold.solver.constraint.streams.bavet.common.Propagator;
import ai.timefold.solver.constraint.streams.bavet.common.StaticPropagationQueue;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.LeftTupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.RightTupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleState;

public abstract class AbstractConcatNode<LeftTuple_ extends AbstractTuple, RightTuple_ extends AbstractTuple, OutTuple_ extends AbstractTuple>
extends AbstractNode
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<RightTuple_> {
    private final int leftSourceTupleCloneStoreIndex;
    private final int rightSourceTupleCloneStoreIndex;
    protected final int outputStoreSize;
    private final StaticPropagationQueue<OutTuple_> propagationQueue;

    protected AbstractConcatNode(TupleLifecycle<OutTuple_> nextNodesTupleLifecycle, int leftSourceTupleCloneStoreIndex, int rightSourceTupleCloneStoreIndex, int outputStoreSize) {
        this.propagationQueue = new StaticPropagationQueue<OutTuple_>(nextNodesTupleLifecycle);
        this.leftSourceTupleCloneStoreIndex = leftSourceTupleCloneStoreIndex;
        this.rightSourceTupleCloneStoreIndex = rightSourceTupleCloneStoreIndex;
        this.outputStoreSize = outputStoreSize;
    }

    protected abstract OutTuple_ getOutTupleFromLeft(LeftTuple_ var1);

    protected abstract OutTuple_ getOutTupleFromRight(RightTuple_ var1);

    protected abstract void updateOutTupleFromLeft(LeftTuple_ var1, OutTuple_ var2);

    protected abstract void updateOutTupleFromRight(RightTuple_ var1, OutTuple_ var2);

    @Override
    public final void insertLeft(LeftTuple_ tuple) {
        OutTuple_ outTuple = this.getOutTupleFromLeft(tuple);
        ((AbstractTuple)tuple).setStore(this.leftSourceTupleCloneStoreIndex, outTuple);
        this.propagationQueue.insert(outTuple);
    }

    @Override
    public final void updateLeft(LeftTuple_ tuple) {
        AbstractTuple outTuple = (AbstractTuple)((AbstractTuple)tuple).getStore(this.leftSourceTupleCloneStoreIndex);
        if (outTuple == null) {
            this.insertLeft(tuple);
            return;
        }
        this.updateOutTupleFromLeft(tuple, outTuple);
        TupleState previousState = outTuple.state;
        if (previousState == TupleState.CREATING || previousState == TupleState.UPDATING) {
            return;
        }
        this.propagationQueue.update((OutTuple_)outTuple);
    }

    @Override
    public final void retractLeft(LeftTuple_ tuple) {
        AbstractTuple outTuple = (AbstractTuple)((AbstractTuple)tuple).getStore(this.leftSourceTupleCloneStoreIndex);
        if (outTuple == null) {
            return;
        }
        TupleState state = outTuple.state;
        if (!state.isActive()) {
            throw new IllegalStateException("Impossible state: The tuple (" + outTuple.state + ") in node (" + this + ") is in an unexpected state (" + outTuple.state + ").");
        }
        this.propagationQueue.retract((OutTuple_)outTuple, state == TupleState.CREATING ? TupleState.ABORTING : TupleState.DYING);
    }

    @Override
    public final void insertRight(RightTuple_ tuple) {
        OutTuple_ outTuple = this.getOutTupleFromRight(tuple);
        ((AbstractTuple)tuple).setStore(this.rightSourceTupleCloneStoreIndex, outTuple);
        this.propagationQueue.insert(outTuple);
    }

    @Override
    public final void updateRight(RightTuple_ tuple) {
        AbstractTuple outTuple = (AbstractTuple)((AbstractTuple)tuple).getStore(this.rightSourceTupleCloneStoreIndex);
        if (outTuple == null) {
            this.insertRight(tuple);
            return;
        }
        this.updateOutTupleFromRight(tuple, outTuple);
        TupleState previousState = outTuple.state;
        if (previousState == TupleState.CREATING || previousState == TupleState.UPDATING) {
            return;
        }
        this.propagationQueue.update((OutTuple_)outTuple);
    }

    @Override
    public final void retractRight(RightTuple_ tuple) {
        AbstractTuple outTuple = (AbstractTuple)((AbstractTuple)tuple).getStore(this.rightSourceTupleCloneStoreIndex);
        if (outTuple == null) {
            return;
        }
        TupleState state = outTuple.state;
        if (!state.isActive()) {
            throw new IllegalStateException("Impossible state: The tuple (" + outTuple.state + ") in node (" + this + ") is in an unexpected state (" + outTuple.state + ").");
        }
        this.propagationQueue.retract((OutTuple_)outTuple, state == TupleState.CREATING ? TupleState.ABORTING : TupleState.DYING);
    }

    @Override
    public Propagator getPropagator() {
        return this.propagationQueue;
    }
}

