/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.bi;

import ai.timefold.solver.constraint.streams.bavet.common.AbstractMapNode;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.BiTuple;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TriTuple;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleLifecycle;
import java.util.Objects;
import java.util.function.BiFunction;

final class MapBiToTriNode<A, B, NewA, NewB, NewC>
extends AbstractMapNode<BiTuple<A, B>, TriTuple<NewA, NewB, NewC>> {
    private final BiFunction<A, B, NewA> mappingFunctionA;
    private final BiFunction<A, B, NewB> mappingFunctionB;
    private final BiFunction<A, B, NewC> mappingFunctionC;

    MapBiToTriNode(int mapStoreIndex, BiFunction<A, B, NewA> mappingFunctionA, BiFunction<A, B, NewB> mappingFunctionB, BiFunction<A, B, NewC> mappingFunctionC, TupleLifecycle<TriTuple<NewA, NewB, NewC>> nextNodesTupleLifecycle, int outputStoreSize) {
        super(mapStoreIndex, nextNodesTupleLifecycle, outputStoreSize);
        this.mappingFunctionA = Objects.requireNonNull(mappingFunctionA);
        this.mappingFunctionB = Objects.requireNonNull(mappingFunctionB);
        this.mappingFunctionC = Objects.requireNonNull(mappingFunctionC);
    }

    @Override
    protected TriTuple<NewA, NewB, NewC> map(BiTuple<A, B> tuple) {
        Object factA = tuple.factA;
        Object factB = tuple.factB;
        return new TriTuple<NewA, NewB, NewC>(this.mappingFunctionA.apply(factA, factB), this.mappingFunctionB.apply(factA, factB), this.mappingFunctionC.apply(factA, factB), this.outputStoreSize);
    }

    @Override
    protected void remap(BiTuple<A, B> inTuple, TriTuple<NewA, NewB, NewC> outTuple) {
        Object factA = inTuple.factA;
        Object factB = inTuple.factB;
        NewA newA = this.mappingFunctionA.apply(factA, factB);
        NewB newB = this.mappingFunctionB.apply(factA, factB);
        NewC newC = this.mappingFunctionC.apply(factA, factB);
        outTuple.factA = newA;
        outTuple.factB = newB;
        outTuple.factC = newC;
    }
}

