/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.bi;

import ai.timefold.solver.constraint.streams.bavet.common.AbstractMapNode;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.BiTuple;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleLifecycle;
import java.util.Objects;
import java.util.function.BiFunction;

final class MapBiToBiNode<A, B, NewA, NewB>
extends AbstractMapNode<BiTuple<A, B>, BiTuple<NewA, NewB>> {
    private final BiFunction<A, B, NewA> mappingFunctionA;
    private final BiFunction<A, B, NewB> mappingFunctionB;

    MapBiToBiNode(int mapStoreIndex, BiFunction<A, B, NewA> mappingFunctionA, BiFunction<A, B, NewB> mappingFunctionB, TupleLifecycle<BiTuple<NewA, NewB>> nextNodesTupleLifecycle, int outputStoreSize) {
        super(mapStoreIndex, nextNodesTupleLifecycle, outputStoreSize);
        this.mappingFunctionA = Objects.requireNonNull(mappingFunctionA);
        this.mappingFunctionB = Objects.requireNonNull(mappingFunctionB);
    }

    @Override
    protected BiTuple<NewA, NewB> map(BiTuple<A, B> tuple) {
        Object factA = tuple.factA;
        Object factB = tuple.factB;
        return new BiTuple<NewA, NewB>(this.mappingFunctionA.apply(factA, factB), this.mappingFunctionB.apply(factA, factB), this.outputStoreSize);
    }

    @Override
    protected void remap(BiTuple<A, B> inTuple, BiTuple<NewA, NewB> outTuple) {
        Object factA = inTuple.factA;
        Object factB = inTuple.factB;
        NewA newA = this.mappingFunctionA.apply(factA, factB);
        NewB newB = this.mappingFunctionB.apply(factA, factB);
        outTuple.factA = newA;
        outTuple.factB = newB;
    }
}

