/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet;

import ai.timefold.solver.constraint.streams.bavet.BavetConstraint;
import ai.timefold.solver.constraint.streams.bavet.BavetConstraintFactory;
import ai.timefold.solver.constraint.streams.bavet.BavetConstraintSession;
import ai.timefold.solver.constraint.streams.bavet.BavetConstraintSessionFactory;
import ai.timefold.solver.constraint.streams.bavet.BavetConstraintStreamScoreDirector;
import ai.timefold.solver.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactory;
import ai.timefold.solver.constraint.streams.common.inliner.AbstractScoreInliner;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import java.util.Arrays;
import java.util.List;

public final class BavetConstraintStreamScoreDirectorFactory<Solution_, Score_ extends Score<Score_>>
extends AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> {
    private final BavetConstraintSessionFactory<Solution_, Score_> constraintSessionFactory;
    private final List<BavetConstraint<Solution_>> constraintList;

    public BavetConstraintStreamScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor, ConstraintProvider constraintProvider, EnvironmentMode environmentMode) {
        super(solutionDescriptor);
        BavetConstraintFactory<Solution_> constraintFactory = new BavetConstraintFactory<Solution_>(solutionDescriptor, environmentMode);
        this.constraintList = constraintFactory.buildConstraints(constraintProvider);
        this.constraintSessionFactory = new BavetConstraintSessionFactory(solutionDescriptor, this.constraintList);
    }

    public BavetConstraintStreamScoreDirector<Solution_, Score_> buildScoreDirector(boolean lookUpEnabled, boolean constraintMatchEnabledPreference, boolean expectShadowVariablesInCorrectState) {
        return new BavetConstraintStreamScoreDirector(this, lookUpEnabled, constraintMatchEnabledPreference, expectShadowVariablesInCorrectState);
    }

    public BavetConstraintSession<Score_> newSession(boolean constraintMatchEnabled, Solution_ workingSolution) {
        return this.constraintSessionFactory.buildSession(constraintMatchEnabled, workingSolution);
    }

    @Override
    public AbstractScoreInliner<Score_> fireAndForget(Object ... facts) {
        BavetConstraintSession<Score_> session = this.newSession(true, null);
        Arrays.stream(facts).forEach(session::insert);
        session.calculateScore(0);
        return session.getScoreInliner();
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    @Override
    public Constraint[] getConstraints() {
        return this.constraintList.toArray(new Constraint[0]);
    }
}

