/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet;

import ai.timefold.solver.constraint.streams.bavet.BavetConstraint;
import ai.timefold.solver.constraint.streams.bavet.BavetConstraintSession;
import ai.timefold.solver.constraint.streams.bavet.common.AbstractConcatNode;
import ai.timefold.solver.constraint.streams.bavet.common.AbstractIfExistsNode;
import ai.timefold.solver.constraint.streams.bavet.common.AbstractJoinNode;
import ai.timefold.solver.constraint.streams.bavet.common.AbstractNode;
import ai.timefold.solver.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.BavetConcatConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.BavetIfExistsConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.BavetJoinConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.BavetStreamBinaryOperation;
import ai.timefold.solver.constraint.streams.bavet.common.NodeBuildHelper;
import ai.timefold.solver.constraint.streams.bavet.common.Propagator;
import ai.timefold.solver.constraint.streams.bavet.uni.AbstractForEachUniNode;
import ai.timefold.solver.constraint.streams.common.inliner.AbstractScoreInliner;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.ConstraintStream;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public final class BavetConstraintSessionFactory<Solution_, Score_ extends Score<Score_>> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final List<BavetConstraint<Solution_>> constraintList;

    public BavetConstraintSessionFactory(SolutionDescriptor<Solution_> solutionDescriptor, List<BavetConstraint<Solution_>> constraintList) {
        this.solutionDescriptor = solutionDescriptor;
        this.constraintList = constraintList;
    }

    public BavetConstraintSession<Score_> buildSession(boolean constraintMatchEnabled, Solution_ workingSolution) {
        ScoreDefinition scoreDefinition = this.solutionDescriptor.getScoreDefinition();
        Score zeroScore = scoreDefinition.getZeroScore();
        LinkedHashSet constraintStreamSet = new LinkedHashSet();
        HashMap constraintWeightMap = new HashMap(this.constraintList.size());
        for (BavetConstraint constraint : this.constraintList) {
            Object constraintWeight = constraint.extractConstraintWeight(workingSolution);
            if (constraintWeight.equals(zeroScore)) continue;
            constraint.collectActiveConstraintStreams(constraintStreamSet);
            constraintWeightMap.put(constraint, constraintWeight);
        }
        Object scoreInliner = AbstractScoreInliner.buildScoreInliner(scoreDefinition, constraintWeightMap, constraintMatchEnabled);
        if (constraintStreamSet.isEmpty()) {
            return new BavetConstraintSession(scoreInliner);
        }
        NodeBuildHelper buildHelper = new NodeBuildHelper((Set<? extends ConstraintStream>)((Set<ConstraintStream>)constraintStreamSet), scoreInliner);
        ArrayList reversedConstraintStreamList = new ArrayList(constraintStreamSet);
        Collections.reverse(reversedConstraintStreamList);
        for (BavetAbstractConstraintStream bavetAbstractConstraintStream : reversedConstraintStreamList) {
            bavetAbstractConstraintStream.buildNode(buildHelper);
        }
        List<AbstractNode> nodeList = buildHelper.destroyAndGetNodeList();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        long nextNodeId = 0L;
        for (AbstractNode abstractNode : nodeList) {
            abstractNode.setId(nextNodeId++);
            abstractNode.setLayerIndex(this.determineLayerIndex(abstractNode, buildHelper));
            if (!(abstractNode instanceof AbstractForEachUniNode)) continue;
            AbstractForEachUniNode forEachUniNode = (AbstractForEachUniNode)abstractNode;
            Class forEachClass = forEachUniNode.getForEachClass();
            List forEachUniNodeList = linkedHashMap.computeIfAbsent(forEachClass, k -> new ArrayList());
            if (forEachUniNodeList.size() == 2) {
                throw new IllegalStateException("Impossible state: For class (" + forEachClass + ") there are already 2 nodes (" + forEachUniNodeList + "), not adding another (" + forEachUniNode + ").");
            }
            forEachUniNodeList.add(forEachUniNode);
        }
        TreeMap<Long, List> layerMap = new TreeMap<Long, List>();
        for (AbstractNode node : nodeList) {
            layerMap.computeIfAbsent(node.getLayerIndex(), k -> new ArrayList()).add(node.getPropagator());
        }
        int n = layerMap.size();
        Propagator[][] layeredNodes = new Propagator[n][];
        for (int i = 0; i < n; ++i) {
            List layer = (List)layerMap.get(i);
            layeredNodes[i] = layer.toArray(new Propagator[0]);
        }
        return new BavetConstraintSession(scoreInliner, linkedHashMap, layeredNodes);
    }

    private long determineLayerIndex(AbstractNode node, NodeBuildHelper<Score_> buildHelper) {
        if (node instanceof AbstractForEachUniNode) {
            return 0L;
        }
        if (node instanceof AbstractJoinNode) {
            AbstractJoinNode joinNode = (AbstractJoinNode)node;
            return this.determineLayerIndexOfBinaryOperation((BavetJoinConstraintStream)((Object)buildHelper.getNodeCreatingStream(joinNode)), buildHelper);
        }
        if (node instanceof AbstractConcatNode) {
            AbstractConcatNode concatNode = (AbstractConcatNode)node;
            return this.determineLayerIndexOfBinaryOperation((BavetConcatConstraintStream)((Object)buildHelper.getNodeCreatingStream(concatNode)), buildHelper);
        }
        if (node instanceof AbstractIfExistsNode) {
            AbstractIfExistsNode ifExistsNode = (AbstractIfExistsNode)node;
            return this.determineLayerIndexOfBinaryOperation((BavetIfExistsConstraintStream)((Object)buildHelper.getNodeCreatingStream(ifExistsNode)), buildHelper);
        }
        BavetAbstractConstraintStream<?> nodeCreator = buildHelper.getNodeCreatingStream(node);
        AbstractNode parentNode = buildHelper.findParentNode(nodeCreator.getParent());
        return parentNode.getLayerIndex() + 1L;
    }

    private long determineLayerIndexOfBinaryOperation(BavetStreamBinaryOperation<?> nodeCreator, NodeBuildHelper<Score_> buildHelper) {
        BavetAbstractConstraintStream<?> leftParent = nodeCreator.getLeftParent();
        BavetAbstractConstraintStream<?> rightParent = nodeCreator.getRightParent();
        AbstractNode leftParentNode = buildHelper.findParentNode(leftParent);
        AbstractNode rightParentNode = buildHelper.findParentNode(rightParent);
        return Math.max(leftParentNode.getLayerIndex(), rightParentNode.getLayerIndex()) + 1L;
    }
}

