/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.client.operations;

import ai.docling.serve.api.DoclingServeConvertApi;
import ai.docling.serve.api.DoclingServeTaskApi;
import ai.docling.serve.api.convert.request.ConvertDocumentRequest;
import ai.docling.serve.api.convert.response.ConvertDocumentResponse;
import ai.docling.serve.api.task.request.TaskResultRequest;
import ai.docling.serve.api.util.ValidationUtils;
import ai.docling.serve.client.operations.AsyncOperations;
import ai.docling.serve.client.operations.HttpOperations;
import ai.docling.serve.client.operations.RequestContext;
import java.time.Duration;
import java.util.concurrent.CompletionStage;

public final class ConvertOperations
extends AsyncOperations
implements DoclingServeConvertApi {
    private final HttpOperations httpOperations;
    private final DoclingServeTaskApi taskApi;

    public ConvertOperations(HttpOperations httpOperations, DoclingServeTaskApi taskApi, Duration asyncPollInterval, Duration asyncTimeout) {
        super(httpOperations, taskApi, asyncPollInterval, asyncTimeout);
        this.httpOperations = httpOperations;
        this.taskApi = taskApi;
    }

    protected ConvertDocumentResponse getTaskResult(TaskResultRequest taskResultRequest) {
        return this.taskApi.convertTaskResult(taskResultRequest);
    }

    public ConvertDocumentResponse convertSource(ConvertDocumentRequest request) {
        ValidationUtils.ensureNotNull((Object)request, (String)"request");
        return this.httpOperations.executePost(this.createRequestContext("/v1/convert/source", request));
    }

    private <I> RequestContext<I, ConvertDocumentResponse> createRequestContext(String uri, I request) {
        return RequestContext.builder().request(request).responseType(ConvertDocumentResponse.class).uri(uri).build();
    }

    public CompletionStage<ConvertDocumentResponse> convertSourceAsync(ConvertDocumentRequest request) {
        return this.executeAsync(request, "/v1/convert/source/async");
    }
}

