/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.client.operations;

import ai.docling.serve.api.DoclingServeTaskApi;
import ai.docling.serve.api.chunk.response.ChunkDocumentResponse;
import ai.docling.serve.api.convert.response.ConvertDocumentResponse;
import ai.docling.serve.api.task.request.TaskResultRequest;
import ai.docling.serve.api.task.request.TaskStatusPollRequest;
import ai.docling.serve.api.task.response.TaskStatusPollResponse;
import ai.docling.serve.api.util.ValidationUtils;
import ai.docling.serve.client.operations.HttpOperations;
import ai.docling.serve.client.operations.RequestContext;

public final class TaskOperations
implements DoclingServeTaskApi {
    private final HttpOperations httpOperations;

    public TaskOperations(HttpOperations httpOperations) {
        this.httpOperations = httpOperations;
    }

    public TaskStatusPollResponse pollTaskStatus(TaskStatusPollRequest request) {
        ValidationUtils.ensureNotNull((Object)request, (String)"request");
        return this.httpOperations.executeGet(this.createRequestContext("/v1/status/poll/%s?wait=%d".formatted(request.getTaskId(), request.getWaitTime().toSeconds()), TaskStatusPollResponse.class));
    }

    public ConvertDocumentResponse convertTaskResult(TaskResultRequest request) {
        ValidationUtils.ensureNotNull((Object)request, (String)"request");
        return this.httpOperations.executeGet(this.createRequestContext("/v1/result/%s".formatted(request.getTaskId()), ConvertDocumentResponse.class));
    }

    public ChunkDocumentResponse chunkTaskResult(TaskResultRequest request) {
        ValidationUtils.ensureNotNull((Object)request, (String)"request");
        return this.httpOperations.executeGet(this.createRequestContext("/v1/result/%s".formatted(request.getTaskId()), ChunkDocumentResponse.class));
    }

    private <O> RequestContext<Object, O> createRequestContext(String uri, Class<O> responseType) {
        return RequestContext.builder().responseType(responseType).uri(uri).build();
    }
}

