/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.api.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import org.jspecify.annotations.Nullable;

public final class ServiceLoaderHelper {
    private ServiceLoaderHelper() {
    }

    public static <T> Optional<T> loadFactory(Class<T> clazz) {
        Collection<T> factories = ServiceLoaderHelper.loadFactories(clazz, null);
        return factories.isEmpty() ? Optional.empty() : Optional.ofNullable(factories.iterator().next());
    }

    public static <T> Collection<T> loadFactories(Class<T> clazz) {
        return ServiceLoaderHelper.loadFactories(clazz, null);
    }

    public static <T> Collection<T> loadFactories(Class<T> clazz, @Nullable ClassLoader classLoader) {
        List<T> factories = Optional.ofNullable(classLoader).map(cl -> ServiceLoaderHelper.loadAll(ServiceLoader.load(clazz, cl))).orElseGet(() -> ServiceLoaderHelper.loadAll(ServiceLoader.load(clazz)));
        List<T> factoriesToReturn = factories.isEmpty() ? ServiceLoaderHelper.loadAll(ServiceLoader.load(clazz, ServiceLoaderHelper.class.getClassLoader())) : factories;
        return factoriesToReturn.stream().filter(Objects::nonNull).toList();
    }

    private static <T> List<T> loadAll(ServiceLoader<T> loader) {
        ArrayList list = new ArrayList();
        loader.iterator().forEachRemaining(list::add);
        return list;
    }
}

