/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.api.convert.response;

import ai.docling.serve.api.convert.response.DocumentResponse;
import ai.docling.serve.api.convert.response.ErrorItem;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import tools.jackson.databind.annotation.JsonDeserialize;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
public class ConvertDocumentResponse {
    @JsonProperty(value="document")
    private final DocumentResponse document;
    @JsonProperty(value="errors")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final List<ErrorItem> errors;
    @JsonProperty(value="processing_time")
    private final Double processingTime;
    @JsonProperty(value="status")
    private final String status;
    @JsonProperty(value="timings")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final Map<String, Object> timings;

    ConvertDocumentResponse(DocumentResponse document, List<ErrorItem> errors, Double processingTime, String status, Map<String, Object> timings) {
        this.document = document;
        this.errors = errors;
        this.processingTime = processingTime;
        this.status = status;
        this.timings = timings;
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public @NonNull Builder toBuilder() {
        Builder builder = new Builder().document(this.document).processingTime(this.processingTime).status(this.status);
        if (this.errors != null) {
            builder.errors(this.errors);
        }
        if (this.timings != null) {
            builder.timings(this.timings);
        }
        return builder;
    }

    public DocumentResponse getDocument() {
        return this.document;
    }

    public List<ErrorItem> getErrors() {
        return this.errors;
    }

    public Double getProcessingTime() {
        return this.processingTime;
    }

    public String getStatus() {
        return this.status;
    }

    public Map<String, Object> getTimings() {
        return this.timings;
    }

    public @NonNull String toString() {
        return "ConvertDocumentResponse(document=" + String.valueOf(this.getDocument()) + ", errors=" + String.valueOf(this.getErrors()) + ", processingTime=" + this.getProcessingTime() + ", status=" + this.getStatus() + ", timings=" + String.valueOf(this.getTimings()) + ")";
    }

    @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private DocumentResponse document;
        private ArrayList<ErrorItem> errors;
        private Double processingTime;
        private String status;
        private ArrayList<String> timings$key;
        private ArrayList<Object> timings$value;

        Builder() {
        }

        @JsonProperty(value="document")
        public @NonNull Builder document(DocumentResponse document) {
            this.document = document;
            return this;
        }

        public @NonNull Builder error(ErrorItem error) {
            if (this.errors == null) {
                this.errors = new ArrayList();
            }
            this.errors.add(error);
            return this;
        }

        @JsonProperty(value="errors")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder errors(@NonNull Collection<? extends ErrorItem> errors) {
            if (errors == null) {
                throw new IllegalArgumentException("errors cannot be null");
            }
            if (this.errors == null) {
                this.errors = new ArrayList();
            }
            this.errors.addAll(errors);
            return this;
        }

        public @NonNull Builder clearErrors() {
            if (this.errors != null) {
                this.errors.clear();
            }
            return this;
        }

        @JsonProperty(value="processing_time")
        public @NonNull Builder processingTime(Double processingTime) {
            this.processingTime = processingTime;
            return this;
        }

        @JsonProperty(value="status")
        public @NonNull Builder status(String status) {
            this.status = status;
            return this;
        }

        public @NonNull Builder timing(String timingKey, Object timingValue) {
            if (this.timings$key == null) {
                this.timings$key = new ArrayList();
                this.timings$value = new ArrayList();
            }
            this.timings$key.add(timingKey);
            this.timings$value.add(timingValue);
            return this;
        }

        @JsonProperty(value="timings")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder timings(@NonNull Map<? extends String, ? extends Object> timings) {
            if (timings == null) {
                throw new IllegalArgumentException("timings cannot be null");
            }
            if (this.timings$key == null) {
                this.timings$key = new ArrayList();
                this.timings$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : timings.entrySet()) {
                this.timings$key.add($lombokEntry.getKey());
                this.timings$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public @NonNull Builder clearTimings() {
            if (this.timings$key != null) {
                this.timings$key.clear();
                this.timings$value.clear();
            }
            return this;
        }

        public @NonNull ConvertDocumentResponse build() {
            Map<String, Object> timings;
            List<ErrorItem> errors = switch (this.errors == null ? 0 : this.errors.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.errors.get(0));
                default -> Collections.unmodifiableList(new ArrayList<ErrorItem>(this.errors));
            };
            switch (this.timings$key == null ? 0 : this.timings$key.size()) {
                case 0: {
                    timings = Collections.emptyMap();
                    break;
                }
                case 1: {
                    timings = Collections.singletonMap(this.timings$key.get(0), this.timings$value.get(0));
                    break;
                }
                default: {
                    timings = new LinkedHashMap(this.timings$key.size() < 0x40000000 ? 1 + this.timings$key.size() + (this.timings$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.timings$key.size(); ++$i) {
                        timings.put(this.timings$key.get($i), this.timings$value.get($i));
                    }
                    timings = Collections.unmodifiableMap(timings);
                }
            }
            return new ConvertDocumentResponse(this.document, errors, this.processingTime, this.status, timings);
        }

        public @NonNull String toString() {
            return "ConvertDocumentResponse.Builder(document=" + String.valueOf(this.document) + ", errors=" + String.valueOf(this.errors) + ", processingTime=" + this.processingTime + ", status=" + this.status + ", timings$key=" + String.valueOf(this.timings$key) + ", timings$value=" + String.valueOf(this.timings$value) + ")";
        }
    }
}

