/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.api.convert.request;

import ai.docling.serve.api.convert.request.options.ConvertDocumentOptions;
import ai.docling.serve.api.convert.request.source.Source;
import ai.docling.serve.api.convert.request.target.Target;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;
import tools.jackson.databind.annotation.JsonDeserialize;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
public class ConvertDocumentRequest {
    @JsonProperty(value="sources")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final List<Source> sources;
    @JsonProperty(value="options")
    @NonNull
    private final ConvertDocumentOptions options;
    @JsonProperty(value="target")
    private final @Nullable Target target;

    private static ConvertDocumentOptions $default$options() {
        return ConvertDocumentOptions.builder().build();
    }

    ConvertDocumentRequest(List<Source> sources, @NonNull ConvertDocumentOptions options, @Nullable Target target) {
        if (options == null) {
            throw new IllegalArgumentException("options is marked non-null but is null");
        }
        this.sources = sources;
        this.options = options;
        this.target = target;
    }

    public static @org.jspecify.annotations.NonNull Builder builder() {
        return new Builder();
    }

    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        Builder builder = new Builder().options(this.options).target(this.target);
        if (this.sources != null) {
            builder.sources(this.sources);
        }
        return builder;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    @NonNull
    public ConvertDocumentOptions getOptions() {
        return this.options;
    }

    public @Nullable Target getTarget() {
        return this.target;
    }

    public @org.jspecify.annotations.NonNull String toString() {
        return "ConvertDocumentRequest(sources=" + String.valueOf(this.getSources()) + ", options=" + String.valueOf(this.getOptions()) + ", target=" + String.valueOf(this.getTarget()) + ")";
    }

    @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private ArrayList<Source> sources;
        private boolean options$set;
        private ConvertDocumentOptions options$value;
        private Target target;

        Builder() {
        }

        public @org.jspecify.annotations.NonNull Builder source(Source source) {
            if (this.sources == null) {
                this.sources = new ArrayList();
            }
            this.sources.add(source);
            return this;
        }

        @JsonProperty(value="sources")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @org.jspecify.annotations.NonNull Builder sources(@org.jspecify.annotations.NonNull Collection<? extends Source> sources) {
            if (sources == null) {
                throw new IllegalArgumentException("sources cannot be null");
            }
            if (this.sources == null) {
                this.sources = new ArrayList();
            }
            this.sources.addAll(sources);
            return this;
        }

        public @org.jspecify.annotations.NonNull Builder clearSources() {
            if (this.sources != null) {
                this.sources.clear();
            }
            return this;
        }

        @JsonProperty(value="options")
        public @org.jspecify.annotations.NonNull Builder options(@NonNull ConvertDocumentOptions options) {
            if (options == null) {
                throw new IllegalArgumentException("options is marked non-null but is null");
            }
            this.options$value = options;
            this.options$set = true;
            return this;
        }

        @JsonProperty(value="target")
        public @org.jspecify.annotations.NonNull Builder target(@Nullable Target target) {
            this.target = target;
            return this;
        }

        public @org.jspecify.annotations.NonNull ConvertDocumentRequest build() {
            List<Source> sources = switch (this.sources == null ? 0 : this.sources.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.sources.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Source>(this.sources));
            };
            ConvertDocumentOptions options$value = this.options$value;
            if (!this.options$set) {
                options$value = ConvertDocumentRequest.$default$options();
            }
            return new ConvertDocumentRequest(sources, options$value, this.target);
        }

        public @org.jspecify.annotations.NonNull String toString() {
            return "ConvertDocumentRequest.Builder(sources=" + String.valueOf(this.sources) + ", options$value=" + String.valueOf(this.options$value) + ", target=" + String.valueOf(this.target) + ")";
        }
    }
}

