/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.api.util;

import ai.docling.serve.api.convert.request.source.FileSource;
import ai.docling.serve.api.util.ValidationUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import java.util.stream.Stream;

public final class FileUtils {
    private FileUtils() {
    }

    public static byte[] getBytes(Path file) throws IOException {
        ValidationUtils.ensureNotNull(file, "file");
        if (!Files.exists(file, new LinkOption[0])) {
            throw new IllegalArgumentException("File (%s) does not exist".formatted(file));
        }
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new IllegalArgumentException("File (%s) is not a regular file".formatted(file));
        }
        if (!Files.isReadable(file)) {
            throw new IllegalArgumentException("File (%s) is not readable".formatted(file));
        }
        return Files.readAllBytes(file);
    }

    public static String convertToBase64(Path file) throws IOException {
        return FileUtils.convertToBase64(FileUtils.getBytes(file));
    }

    public static String convertToBase64(byte[] bytes) {
        ValidationUtils.ensureNotNull(bytes, "bytes");
        return bytes.length == 0 ? "" : Base64.getEncoder().encodeToString(bytes);
    }

    public static Stream<FileSource> createFileSources(Path ... files) {
        ValidationUtils.ensureNotEmpty(files, "files");
        return Arrays.stream(files).filter(Objects::nonNull).map(file -> {
            try {
                return FileSource.builder().filename(file.getFileName().toString()).base64String(FileUtils.convertToBase64(file)).build();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

