/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.api.serialization;

import ai.docling.serve.api.serialization.DurationSerializationFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;

public class Jackson2DurationSerializer
extends JsonSerializer<Duration>
implements ContextualSerializer {
    private final ChronoUnit unit;

    public Jackson2DurationSerializer() {
        this(ChronoUnit.SECONDS);
    }

    public Jackson2DurationSerializer(ChronoUnit unit) {
        this.unit = unit;
    }

    public void serialize(Duration value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        switch (this.unit) {
            case NANOS: {
                gen.writeNumber(value.toNanos());
                break;
            }
            case MICROS: {
                gen.writeNumber(value.toNanos() / 1000L);
                break;
            }
            case MILLIS: {
                gen.writeNumber(value.toMillis());
                break;
            }
            case MINUTES: {
                gen.writeNumber(value.toMinutes());
                break;
            }
            case HOURS: {
                gen.writeNumber(value.toHours());
                break;
            }
            case DAYS: {
                gen.writeNumber(value.toDays());
                break;
            }
            default: {
                gen.writeNumber(value.getSeconds());
            }
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) {
        return Optional.ofNullable(property).map(p -> (DurationSerializationFormat)p.getAnnotation(DurationSerializationFormat.class)).map(annotation -> new Jackson2DurationSerializer(annotation.value())).orElse(this);
    }
}

