/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.api.convert.request.options;

import ai.docling.serve.api.convert.request.options.ResponseFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import tools.jackson.databind.annotation.JsonDeserialize;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
public class VlmModelLocal {
    @JsonProperty(value="repo_id")
    private final @Nullable String repoId;
    @JsonProperty(value="prompt")
    private final @Nullable String prompt;
    @JsonProperty(value="scale")
    private final @Nullable Integer scale;
    @JsonProperty(value="response_format")
    private final @Nullable ResponseFormat responseFormat;
    @JsonProperty(value="inference_framework")
    private final @Nullable InferenceFramework inferenceFramework;
    @JsonProperty(value="transformers_model_type")
    private final @Nullable TransformersModelType transformersModelType;
    @JsonProperty(value="extra_generation_config")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final Map<String, Object> extraGenerationConfig;

    VlmModelLocal(@Nullable String repoId, @Nullable String prompt, @Nullable Integer scale, @Nullable ResponseFormat responseFormat, @Nullable InferenceFramework inferenceFramework, @Nullable TransformersModelType transformersModelType, Map<String, Object> extraGenerationConfig) {
        this.repoId = repoId;
        this.prompt = prompt;
        this.scale = scale;
        this.responseFormat = responseFormat;
        this.inferenceFramework = inferenceFramework;
        this.transformersModelType = transformersModelType;
        this.extraGenerationConfig = extraGenerationConfig;
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public @NonNull Builder toBuilder() {
        Builder builder = new Builder().repoId(this.repoId).prompt(this.prompt).scale(this.scale).responseFormat(this.responseFormat).inferenceFramework(this.inferenceFramework).transformersModelType(this.transformersModelType);
        if (this.extraGenerationConfig != null) {
            builder.extraGenerationConfig(this.extraGenerationConfig);
        }
        return builder;
    }

    public @Nullable String getRepoId() {
        return this.repoId;
    }

    public @Nullable String getPrompt() {
        return this.prompt;
    }

    public @Nullable Integer getScale() {
        return this.scale;
    }

    public @Nullable ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public @Nullable InferenceFramework getInferenceFramework() {
        return this.inferenceFramework;
    }

    public @Nullable TransformersModelType getTransformersModelType() {
        return this.transformersModelType;
    }

    public Map<String, Object> getExtraGenerationConfig() {
        return this.extraGenerationConfig;
    }

    public @NonNull String toString() {
        return "VlmModelLocal(repoId=" + this.getRepoId() + ", prompt=" + this.getPrompt() + ", scale=" + this.getScale() + ", responseFormat=" + String.valueOf((Object)this.getResponseFormat()) + ", inferenceFramework=" + String.valueOf((Object)this.getInferenceFramework()) + ", transformersModelType=" + String.valueOf((Object)this.getTransformersModelType()) + ", extraGenerationConfig=" + String.valueOf(this.getExtraGenerationConfig()) + ")";
    }

    public static enum InferenceFramework {
        MLX,
        TRANSFORMERS,
        VLLM;

    }

    public static enum TransformersModelType {
        AUTOMODEL,
        AUTOMODEL_VISION2SEQ,
        AUTOMODEL_CAUSALLM,
        AUTOMODEL_IMAGETEXTTOTEXT;

    }

    @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private String repoId;
        private String prompt;
        private Integer scale;
        private ResponseFormat responseFormat;
        private InferenceFramework inferenceFramework;
        private TransformersModelType transformersModelType;
        private ArrayList<String> extraGenerationConfig$key;
        private ArrayList<Object> extraGenerationConfig$value;

        Builder() {
        }

        @JsonProperty(value="repo_id")
        public @NonNull Builder repoId(@Nullable String repoId) {
            this.repoId = repoId;
            return this;
        }

        @JsonProperty(value="prompt")
        public @NonNull Builder prompt(@Nullable String prompt) {
            this.prompt = prompt;
            return this;
        }

        @JsonProperty(value="scale")
        public @NonNull Builder scale(@Nullable Integer scale) {
            this.scale = scale;
            return this;
        }

        @JsonProperty(value="response_format")
        public @NonNull Builder responseFormat(@Nullable ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        @JsonProperty(value="inference_framework")
        public @NonNull Builder inferenceFramework(@Nullable InferenceFramework inferenceFramework) {
            this.inferenceFramework = inferenceFramework;
            return this;
        }

        @JsonProperty(value="transformers_model_type")
        public @NonNull Builder transformersModelType(@Nullable TransformersModelType transformersModelType) {
            this.transformersModelType = transformersModelType;
            return this;
        }

        public @NonNull Builder extraGenerationConfig(String extraGenerationConfigKey, Object extraGenerationConfigValue) {
            if (this.extraGenerationConfig$key == null) {
                this.extraGenerationConfig$key = new ArrayList();
                this.extraGenerationConfig$value = new ArrayList();
            }
            this.extraGenerationConfig$key.add(extraGenerationConfigKey);
            this.extraGenerationConfig$value.add(extraGenerationConfigValue);
            return this;
        }

        @JsonProperty(value="extra_generation_config")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder extraGenerationConfig(@NonNull Map<? extends String, ? extends Object> extraGenerationConfig) {
            if (extraGenerationConfig == null) {
                throw new IllegalArgumentException("extraGenerationConfig cannot be null");
            }
            if (this.extraGenerationConfig$key == null) {
                this.extraGenerationConfig$key = new ArrayList();
                this.extraGenerationConfig$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : extraGenerationConfig.entrySet()) {
                this.extraGenerationConfig$key.add($lombokEntry.getKey());
                this.extraGenerationConfig$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public @NonNull Builder clearExtraGenerationConfig() {
            if (this.extraGenerationConfig$key != null) {
                this.extraGenerationConfig$key.clear();
                this.extraGenerationConfig$value.clear();
            }
            return this;
        }

        public @NonNull VlmModelLocal build() {
            Map<String, Object> extraGenerationConfig;
            switch (this.extraGenerationConfig$key == null ? 0 : this.extraGenerationConfig$key.size()) {
                case 0: {
                    extraGenerationConfig = Collections.emptyMap();
                    break;
                }
                case 1: {
                    extraGenerationConfig = Collections.singletonMap(this.extraGenerationConfig$key.get(0), this.extraGenerationConfig$value.get(0));
                    break;
                }
                default: {
                    extraGenerationConfig = new LinkedHashMap(this.extraGenerationConfig$key.size() < 0x40000000 ? 1 + this.extraGenerationConfig$key.size() + (this.extraGenerationConfig$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.extraGenerationConfig$key.size(); ++$i) {
                        extraGenerationConfig.put(this.extraGenerationConfig$key.get($i), this.extraGenerationConfig$value.get($i));
                    }
                    extraGenerationConfig = Collections.unmodifiableMap(extraGenerationConfig);
                }
            }
            return new VlmModelLocal(this.repoId, this.prompt, this.scale, this.responseFormat, this.inferenceFramework, this.transformersModelType, extraGenerationConfig);
        }

        public @NonNull String toString() {
            return "VlmModelLocal.Builder(repoId=" + this.repoId + ", prompt=" + this.prompt + ", scale=" + this.scale + ", responseFormat=" + String.valueOf((Object)this.responseFormat) + ", inferenceFramework=" + String.valueOf((Object)this.inferenceFramework) + ", transformersModelType=" + String.valueOf((Object)this.transformersModelType) + ", extraGenerationConfig$key=" + String.valueOf(this.extraGenerationConfig$key) + ", extraGenerationConfig$value=" + String.valueOf(this.extraGenerationConfig$value) + ")";
        }
    }
}

