/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TString;

@OpMetadata(opType="EnqueueTPUEmbeddingBatch", inputsClass=Inputs.class)
public final class EnqueueTPUEmbeddingBatch
extends RawOp {
    public static final String OP_NAME = "EnqueueTPUEmbeddingBatch";

    public EnqueueTPUEmbeddingBatch(Operation operation) {
        super(operation, OP_NAME);
    }

    public static EnqueueTPUEmbeddingBatch create(Scope scope, Iterable<Operand<TString>> batch, Operand<TString> modeOverride, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(batch));
        opBuilder.addInput(modeOverride.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.deviceOrdinal != null) {
                    opBuilder.setAttr("device_ordinal", opts.deviceOrdinal);
                }
                if (opts.combiners == null) continue;
                String[] combinersArray = new String[opts.combiners.size()];
                for (int i = 0; i < combinersArray.length; ++i) {
                    combinersArray[i] = opts.combiners.get(i);
                }
                opBuilder.setAttr("combiners", combinersArray);
            }
        }
        return new EnqueueTPUEmbeddingBatch(opBuilder.build());
    }

    public static Options deviceOrdinal(Long deviceOrdinal) {
        return new Options().deviceOrdinal(deviceOrdinal);
    }

    public static Options combiners(List<String> combiners) {
        return new Options().combiners(combiners);
    }

    public static Options combiners(String ... combiners) {
        return new Options().combiners(combiners);
    }

    @OpInputsMetadata(outputsClass=EnqueueTPUEmbeddingBatch.class)
    public static class Inputs
    extends RawOpInputs<EnqueueTPUEmbeddingBatch> {
        public final Iterable<Operand<TString>> batch;
        public final Operand<TString> modeOverride;
        public final long deviceOrdinal;
        public final String[] combiners;

        public Inputs(GraphOperation op) {
            super(new EnqueueTPUEmbeddingBatch(op), op, Arrays.asList("device_ordinal", "combiners"));
            int inputIndex = 0;
            int batchLength = op.inputListLength("batch");
            this.batch = Arrays.asList((Operand[])op.inputList(inputIndex, batchLength));
            inputIndex += batchLength;
            this.modeOverride = op.input(inputIndex++);
            this.deviceOrdinal = op.attributes().getAttrInt("device_ordinal");
            this.combiners = op.attributes().getAttrStringList("combiners");
        }
    }

    public static class Options {
        private Long deviceOrdinal;
        private List<String> combiners;

        private Options() {
        }

        public Options deviceOrdinal(Long deviceOrdinal) {
            this.deviceOrdinal = deviceOrdinal;
            return this;
        }

        public Options combiners(List<String> combiners) {
            this.combiners = combiners;
            return this;
        }

        public Options combiners(String ... combiners) {
            this.combiners = Arrays.asList(combiners);
            return this;
        }
    }
}

