/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="SparseMatMul", inputsClass=Inputs.class)
public final class SparseMatMul
extends RawOp
implements Operand<TFloat32> {
    public static final String OP_NAME = "SparseMatMul";
    private Output<TFloat32> product;

    public SparseMatMul(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.product = operation.output(outputIdx++);
    }

    public static SparseMatMul create(Scope scope, Operand<? extends TNumber> a, Operand<? extends TNumber> b, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(a.asOutput());
        opBuilder.addInput(b.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.transposeA != null) {
                    opBuilder.setAttr("transpose_a", opts.transposeA);
                }
                if (opts.transposeB != null) {
                    opBuilder.setAttr("transpose_b", opts.transposeB);
                }
                if (opts.aIsSparse != null) {
                    opBuilder.setAttr("a_is_sparse", opts.aIsSparse);
                }
                if (opts.bIsSparse == null) continue;
                opBuilder.setAttr("b_is_sparse", opts.bIsSparse);
            }
        }
        return new SparseMatMul(opBuilder.build());
    }

    public static Options transposeA(Boolean transposeA) {
        return new Options().transposeA(transposeA);
    }

    public static Options transposeB(Boolean transposeB) {
        return new Options().transposeB(transposeB);
    }

    public static Options aIsSparse(Boolean aIsSparse) {
        return new Options().aIsSparse(aIsSparse);
    }

    public static Options bIsSparse(Boolean bIsSparse) {
        return new Options().bIsSparse(bIsSparse);
    }

    public Output<TFloat32> product() {
        return this.product;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.product;
    }

    @OpInputsMetadata(outputsClass=SparseMatMul.class)
    public static class Inputs
    extends RawOpInputs<SparseMatMul> {
        public final Operand<? extends TNumber> a;
        public final Operand<? extends TNumber> b;
        public final boolean transposeA;
        public final boolean transposeB;
        public final boolean aIsSparse;
        public final boolean bIsSparse;
        public final DataType Ta;
        public final DataType Tb;

        public Inputs(GraphOperation op) {
            super(new SparseMatMul(op), op, Arrays.asList("transpose_a", "transpose_b", "a_is_sparse", "b_is_sparse", "Ta", "Tb"));
            int inputIndex = 0;
            this.a = op.input(inputIndex++);
            this.b = op.input(inputIndex++);
            this.transposeA = op.attributes().getAttrBool("transpose_a");
            this.transposeB = op.attributes().getAttrBool("transpose_b");
            this.aIsSparse = op.attributes().getAttrBool("a_is_sparse");
            this.bIsSparse = op.attributes().getAttrBool("b_is_sparse");
            this.Ta = op.attributes().getAttrType("Ta");
            this.Tb = op.attributes().getAttrType("Tb");
        }
    }

    public static class Options {
        private Boolean transposeA;
        private Boolean transposeB;
        private Boolean aIsSparse;
        private Boolean bIsSparse;

        private Options() {
        }

        public Options transposeA(Boolean transposeA) {
            this.transposeA = transposeA;
            return this;
        }

        public Options transposeB(Boolean transposeB) {
            this.transposeB = transposeB;
            return this;
        }

        public Options aIsSparse(Boolean aIsSparse) {
            this.aIsSparse = aIsSparse;
            return this;
        }

        public Options bIsSparse(Boolean bIsSparse) {
            this.bIsSparse = bIsSparse;
            return this;
        }
    }
}

