/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.ragged;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RaggedGather", inputsClass=Inputs.class)
public final class RaggedGather<T extends TNumber, U extends TType>
extends RawOp {
    public static final String OP_NAME = "RaggedGather";
    private List<Output<T>> outputNestedSplits;
    private Output<U> outputDenseValues;

    public RaggedGather(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputNestedSplitsLength = operation.outputListLength("output_nested_splits");
        this.outputNestedSplits = Arrays.asList(operation.outputList(outputIdx, outputNestedSplitsLength));
        outputIdx += outputNestedSplitsLength;
        this.outputDenseValues = operation.output(outputIdx++);
    }

    public static <T extends TNumber, U extends TType> RaggedGather<T, U> create(Scope scope, Iterable<Operand<T>> paramsNestedSplits, Operand<U> paramsDenseValues, Operand<? extends TNumber> indices, Long OUTPUTRAGGEDRANK) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(paramsNestedSplits));
        opBuilder.addInput(paramsDenseValues.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder.setAttr("OUTPUT_RAGGED_RANK", OUTPUTRAGGEDRANK);
        return new RaggedGather<T, U>(opBuilder.build());
    }

    public List<Output<T>> outputNestedSplits() {
        return this.outputNestedSplits;
    }

    public Output<U> outputDenseValues() {
        return this.outputDenseValues;
    }

    @OpInputsMetadata(outputsClass=RaggedGather.class)
    public static class Inputs<T extends TNumber, U extends TType>
    extends RawOpInputs<RaggedGather<T, U>> {
        public final Iterable<Operand<T>> paramsNestedSplits;
        public final Operand<U> paramsDenseValues;
        public final Operand<? extends TNumber> indices;
        public final DataType Tvalues;
        public final DataType Tindices;
        public final DataType Tsplits;

        public Inputs(GraphOperation op) {
            super(new RaggedGather(op), op, Arrays.asList("Tvalues", "Tindices", "Tsplits"));
            int inputIndex = 0;
            int paramsNestedSplitsLength = op.inputListLength("params_nested_splits");
            this.paramsNestedSplits = Arrays.asList((Operand[])op.inputList(inputIndex, paramsNestedSplitsLength));
            inputIndex += paramsNestedSplitsLength;
            this.paramsDenseValues = op.input(inputIndex++);
            this.indices = op.input(inputIndex++);
            this.Tvalues = op.attributes().getAttrType("Tvalues");
            this.Tindices = op.attributes().getAttrType("Tindices");
            this.Tsplits = op.attributes().getAttrType("Tsplits");
        }
    }
}

