/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.ragged;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RaggedFillEmptyRows", inputsClass=Inputs.class)
public final class RaggedFillEmptyRows<T extends TType>
extends RawOp {
    public static final String OP_NAME = "RaggedFillEmptyRows";
    private Output<TInt64> outputValueRowids;
    private Output<T> outputValues;
    private Output<TBool> emptyRowIndicator;
    private Output<TInt64> reverseIndexMap;

    public RaggedFillEmptyRows(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputValueRowids = operation.output(outputIdx++);
        this.outputValues = operation.output(outputIdx++);
        this.emptyRowIndicator = operation.output(outputIdx++);
        this.reverseIndexMap = operation.output(outputIdx++);
    }

    public static <T extends TType> RaggedFillEmptyRows<T> create(Scope scope, Operand<TInt64> valueRowids, Operand<T> values, Operand<TInt64> nrows, Operand<T> defaultValue) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(valueRowids.asOutput());
        opBuilder.addInput(values.asOutput());
        opBuilder.addInput(nrows.asOutput());
        opBuilder.addInput(defaultValue.asOutput());
        return new RaggedFillEmptyRows<T>(opBuilder.build());
    }

    public Output<TInt64> outputValueRowids() {
        return this.outputValueRowids;
    }

    public Output<T> outputValues() {
        return this.outputValues;
    }

    public Output<TBool> emptyRowIndicator() {
        return this.emptyRowIndicator;
    }

    public Output<TInt64> reverseIndexMap() {
        return this.reverseIndexMap;
    }

    @OpInputsMetadata(outputsClass=RaggedFillEmptyRows.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<RaggedFillEmptyRows<T>> {
        public final Operand<TInt64> valueRowids;
        public final Operand<T> values;
        public final Operand<TInt64> nrows;
        public final Operand<T> defaultValue;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new RaggedFillEmptyRows(op), op, Arrays.asList("T"));
            int inputIndex = 0;
            this.valueRowids = op.input(inputIndex++);
            this.values = op.input(inputIndex++);
            this.nrows = op.input(inputIndex++);
            this.defaultValue = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
        }
    }
}

