/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.quantization;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="UniformQuantizedDot", inputsClass=Inputs.class)
public final class UniformQuantizedDot<U extends TNumber>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "UniformQuantizedDot";
    private Output<U> output;

    public UniformQuantizedDot(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <U extends TNumber, T extends TNumber> UniformQuantizedDot<U> create(Scope scope, Operand<T> lhs, Operand<T> rhs, Operand<TFloat32> lhsScales, Operand<TInt32> lhsZeroPoints, Operand<TFloat32> rhsScales, Operand<TInt32> rhsZeroPoints, Operand<TFloat32> outputScales, Operand<TInt32> outputZeroPoints, Class<U> Tout, Long lhsQuantizationMinVal, Long lhsQuantizationMaxVal, Long rhsQuantizationMinVal, Long rhsQuantizationMaxVal, Long outputQuantizationMinVal, Long outputQuantizationMaxVal, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(lhs.asOutput());
        opBuilder.addInput(rhs.asOutput());
        opBuilder.addInput(lhsScales.asOutput());
        opBuilder.addInput(lhsZeroPoints.asOutput());
        opBuilder.addInput(rhsScales.asOutput());
        opBuilder.addInput(rhsZeroPoints.asOutput());
        opBuilder.addInput(outputScales.asOutput());
        opBuilder.addInput(outputZeroPoints.asOutput());
        opBuilder.setAttr("Tout", Operands.toDataType(Tout));
        opBuilder.setAttr("lhs_quantization_min_val", lhsQuantizationMinVal);
        opBuilder.setAttr("lhs_quantization_max_val", lhsQuantizationMaxVal);
        opBuilder.setAttr("rhs_quantization_min_val", rhsQuantizationMinVal);
        opBuilder.setAttr("rhs_quantization_max_val", rhsQuantizationMaxVal);
        opBuilder.setAttr("output_quantization_min_val", outputQuantizationMinVal);
        opBuilder.setAttr("output_quantization_max_val", outputQuantizationMaxVal);
        if (options != null) {
            for (Options opts : options) {
                if (opts.lhsQuantizationAxis != null) {
                    opBuilder.setAttr("lhs_quantization_axis", opts.lhsQuantizationAxis);
                }
                if (opts.rhsQuantizationAxis != null) {
                    opBuilder.setAttr("rhs_quantization_axis", opts.rhsQuantizationAxis);
                }
                if (opts.outputQuantizationAxis == null) continue;
                opBuilder.setAttr("output_quantization_axis", opts.outputQuantizationAxis);
            }
        }
        return new UniformQuantizedDot<U>(opBuilder.build());
    }

    public static Options lhsQuantizationAxis(Long lhsQuantizationAxis) {
        return new Options().lhsQuantizationAxis(lhsQuantizationAxis);
    }

    public static Options rhsQuantizationAxis(Long rhsQuantizationAxis) {
        return new Options().rhsQuantizationAxis(rhsQuantizationAxis);
    }

    public static Options outputQuantizationAxis(Long outputQuantizationAxis) {
        return new Options().outputQuantizationAxis(outputQuantizationAxis);
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=UniformQuantizedDot.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<UniformQuantizedDot<?>> {
        public final Operand<T> lhs;
        public final Operand<T> rhs;
        public final Operand<TFloat32> lhsScales;
        public final Operand<TInt32> lhsZeroPoints;
        public final Operand<TFloat32> rhsScales;
        public final Operand<TInt32> rhsZeroPoints;
        public final Operand<TFloat32> outputScales;
        public final Operand<TInt32> outputZeroPoints;
        public final DataType Tin;
        public final DataType Tout;
        public final long lhsQuantizationAxis;
        public final long lhsQuantizationMinVal;
        public final long lhsQuantizationMaxVal;
        public final long rhsQuantizationAxis;
        public final long rhsQuantizationMinVal;
        public final long rhsQuantizationMaxVal;
        public final long outputQuantizationAxis;
        public final long outputQuantizationMinVal;
        public final long outputQuantizationMaxVal;

        public Inputs(GraphOperation op) {
            super(new UniformQuantizedDot(op), op, Arrays.asList("Tin", "Tout", "lhs_quantization_axis", "lhs_quantization_min_val", "lhs_quantization_max_val", "rhs_quantization_axis", "rhs_quantization_min_val", "rhs_quantization_max_val", "output_quantization_axis", "output_quantization_min_val", "output_quantization_max_val"));
            int inputIndex = 0;
            this.lhs = op.input(inputIndex++);
            this.rhs = op.input(inputIndex++);
            this.lhsScales = op.input(inputIndex++);
            this.lhsZeroPoints = op.input(inputIndex++);
            this.rhsScales = op.input(inputIndex++);
            this.rhsZeroPoints = op.input(inputIndex++);
            this.outputScales = op.input(inputIndex++);
            this.outputZeroPoints = op.input(inputIndex++);
            this.Tin = op.attributes().getAttrType("Tin");
            this.Tout = op.attributes().getAttrType("Tout");
            this.lhsQuantizationAxis = op.attributes().getAttrInt("lhs_quantization_axis");
            this.lhsQuantizationMinVal = op.attributes().getAttrInt("lhs_quantization_min_val");
            this.lhsQuantizationMaxVal = op.attributes().getAttrInt("lhs_quantization_max_val");
            this.rhsQuantizationAxis = op.attributes().getAttrInt("rhs_quantization_axis");
            this.rhsQuantizationMinVal = op.attributes().getAttrInt("rhs_quantization_min_val");
            this.rhsQuantizationMaxVal = op.attributes().getAttrInt("rhs_quantization_max_val");
            this.outputQuantizationAxis = op.attributes().getAttrInt("output_quantization_axis");
            this.outputQuantizationMinVal = op.attributes().getAttrInt("output_quantization_min_val");
            this.outputQuantizationMaxVal = op.attributes().getAttrInt("output_quantization_max_val");
        }
    }

    public static class Options {
        private Long lhsQuantizationAxis;
        private Long rhsQuantizationAxis;
        private Long outputQuantizationAxis;

        private Options() {
        }

        public Options lhsQuantizationAxis(Long lhsQuantizationAxis) {
            this.lhsQuantizationAxis = lhsQuantizationAxis;
            return this;
        }

        public Options rhsQuantizationAxis(Long rhsQuantizationAxis) {
            this.rhsQuantizationAxis = rhsQuantizationAxis;
            return this;
        }

        public Options outputQuantizationAxis(Long outputQuantizationAxis) {
            this.outputQuantizationAxis = outputQuantizationAxis;
            return this;
        }
    }
}

