/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.quantization;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="UniformQuantize", inputsClass=Inputs.class)
public final class UniformQuantize<U extends TNumber>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "UniformQuantize";
    private Output<U> output;

    public UniformQuantize(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <U extends TNumber> UniformQuantize<U> create(Scope scope, Operand<? extends TNumber> input, Operand<TFloat32> scales, Operand<TInt32> zeroPoints, Class<U> Tout, Long quantizationMinVal, Long quantizationMaxVal, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(scales.asOutput());
        opBuilder.addInput(zeroPoints.asOutput());
        opBuilder.setAttr("Tout", Operands.toDataType(Tout));
        opBuilder.setAttr("quantization_min_val", quantizationMinVal);
        opBuilder.setAttr("quantization_max_val", quantizationMaxVal);
        if (options != null) {
            for (Options opts : options) {
                if (opts.quantizationAxis == null) continue;
                opBuilder.setAttr("quantization_axis", opts.quantizationAxis);
            }
        }
        return new UniformQuantize<U>(opBuilder.build());
    }

    public static Options quantizationAxis(Long quantizationAxis) {
        return new Options().quantizationAxis(quantizationAxis);
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=UniformQuantize.class)
    public static class Inputs
    extends RawOpInputs<UniformQuantize<?>> {
        public final Operand<? extends TNumber> input;
        public final Operand<TFloat32> scales;
        public final Operand<TInt32> zeroPoints;
        public final DataType Tin;
        public final DataType Tout;
        public final long quantizationAxis;
        public final long quantizationMinVal;
        public final long quantizationMaxVal;

        public Inputs(GraphOperation op) {
            super(new UniformQuantize(op), op, Arrays.asList("Tin", "Tout", "quantization_axis", "quantization_min_val", "quantization_max_val"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.scales = op.input(inputIndex++);
            this.zeroPoints = op.input(inputIndex++);
            this.Tin = op.attributes().getAttrType("Tin");
            this.Tout = op.attributes().getAttrType("Tout");
            this.quantizationAxis = op.attributes().getAttrInt("quantization_axis");
            this.quantizationMinVal = op.attributes().getAttrInt("quantization_min_val");
            this.quantizationMaxVal = op.attributes().getAttrInt("quantization_max_val");
        }
    }

    public static class Options {
        private Long quantizationAxis;

        private Options() {
        }

        public Options quantizationAxis(Long quantizationAxis) {
            this.quantizationAxis = quantizationAxis;
            return this;
        }
    }
}

