/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="QuantizedBatchNormWithGlobalNormalization", inputsClass=Inputs.class)
public final class QuantizedBatchNormWithGlobalNormalization<U extends TNumber>
extends RawOp {
    public static final String OP_NAME = "QuantizedBatchNormWithGlobalNormalization";
    private Output<U> result;
    private Output<TFloat32> resultMin;
    private Output<TFloat32> resultMax;

    public QuantizedBatchNormWithGlobalNormalization(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.result = operation.output(outputIdx++);
        this.resultMin = operation.output(outputIdx++);
        this.resultMax = operation.output(outputIdx++);
    }

    public static <U extends TNumber, T extends TNumber> QuantizedBatchNormWithGlobalNormalization<U> create(Scope scope, Operand<T> t, Operand<TFloat32> tMin, Operand<TFloat32> tMax, Operand<T> m, Operand<TFloat32> mMin, Operand<TFloat32> mMax, Operand<T> v, Operand<TFloat32> vMin, Operand<TFloat32> vMax, Operand<T> beta, Operand<TFloat32> betaMin, Operand<TFloat32> betaMax, Operand<T> gamma, Operand<TFloat32> gammaMin, Operand<TFloat32> gammaMax, Class<U> outType, Float varianceEpsilon, Boolean scaleAfterNormalization) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(t.asOutput());
        opBuilder.addInput(tMin.asOutput());
        opBuilder.addInput(tMax.asOutput());
        opBuilder.addInput(m.asOutput());
        opBuilder.addInput(mMin.asOutput());
        opBuilder.addInput(mMax.asOutput());
        opBuilder.addInput(v.asOutput());
        opBuilder.addInput(vMin.asOutput());
        opBuilder.addInput(vMax.asOutput());
        opBuilder.addInput(beta.asOutput());
        opBuilder.addInput(betaMin.asOutput());
        opBuilder.addInput(betaMax.asOutput());
        opBuilder.addInput(gamma.asOutput());
        opBuilder.addInput(gammaMin.asOutput());
        opBuilder.addInput(gammaMax.asOutput());
        opBuilder.setAttr("out_type", Operands.toDataType(outType));
        opBuilder.setAttr("variance_epsilon", varianceEpsilon.floatValue());
        opBuilder.setAttr("scale_after_normalization", scaleAfterNormalization);
        return new QuantizedBatchNormWithGlobalNormalization<U>(opBuilder.build());
    }

    public Output<U> result() {
        return this.result;
    }

    public Output<TFloat32> resultMin() {
        return this.resultMin;
    }

    public Output<TFloat32> resultMax() {
        return this.resultMax;
    }

    @OpInputsMetadata(outputsClass=QuantizedBatchNormWithGlobalNormalization.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<QuantizedBatchNormWithGlobalNormalization<?>> {
        public final Operand<T> t;
        public final Operand<TFloat32> tMin;
        public final Operand<TFloat32> tMax;
        public final Operand<T> m;
        public final Operand<TFloat32> mMin;
        public final Operand<TFloat32> mMax;
        public final Operand<T> v;
        public final Operand<TFloat32> vMin;
        public final Operand<TFloat32> vMax;
        public final Operand<T> beta;
        public final Operand<TFloat32> betaMin;
        public final Operand<TFloat32> betaMax;
        public final Operand<T> gamma;
        public final Operand<TFloat32> gammaMin;
        public final Operand<TFloat32> gammaMax;
        public final DataType Tinput;
        public final DataType outType;
        public final float varianceEpsilon;
        public final boolean scaleAfterNormalization;

        public Inputs(GraphOperation op) {
            super(new QuantizedBatchNormWithGlobalNormalization(op), op, Arrays.asList("Tinput", "out_type", "variance_epsilon", "scale_after_normalization"));
            int inputIndex = 0;
            this.t = op.input(inputIndex++);
            this.tMin = op.input(inputIndex++);
            this.tMax = op.input(inputIndex++);
            this.m = op.input(inputIndex++);
            this.mMin = op.input(inputIndex++);
            this.mMax = op.input(inputIndex++);
            this.v = op.input(inputIndex++);
            this.vMin = op.input(inputIndex++);
            this.vMax = op.input(inputIndex++);
            this.beta = op.input(inputIndex++);
            this.betaMin = op.input(inputIndex++);
            this.betaMax = op.input(inputIndex++);
            this.gamma = op.input(inputIndex++);
            this.gammaMin = op.input(inputIndex++);
            this.gammaMax = op.input(inputIndex++);
            this.Tinput = op.attributes().getAttrType("Tinput");
            this.outType = op.attributes().getAttrType("out_type");
            this.varianceEpsilon = op.attributes().getAttrFloat("variance_epsilon");
            this.scaleAfterNormalization = op.attributes().getAttrBool("scale_after_normalization");
        }
    }
}

