/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SnapshotDatasetV2", inputsClass=Inputs.class)
public final class SnapshotDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "SnapshotDatasetV2";
    private Output<? extends TType> handle;

    public SnapshotDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static SnapshotDataset create(Scope scope, Operand<? extends TType> inputDataset, Operand<TString> path, Iterable<Operand<?>> readerFuncOtherArgs, Iterable<Operand<?>> shardFuncOtherArgs, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, ConcreteFunction readerFunc, ConcreteFunction shardFunc, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "SnapshotDataset");
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(path.asOutput());
        opBuilder.addInputList(Operands.asOutputs(readerFuncOtherArgs));
        opBuilder.addInputList(Operands.asOutputs(shardFuncOtherArgs));
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        opBuilder.setAttr("reader_func", readerFunc);
        opBuilder.setAttr("shard_func", shardFunc);
        if (options != null) {
            for (Options opts : options) {
                if (opts.compression != null) {
                    opBuilder.setAttr("compression", opts.compression);
                }
                if (opts.readerPrefix != null) {
                    opBuilder.setAttr("reader_prefix", opts.readerPrefix);
                }
                if (opts.writerPrefix != null) {
                    opBuilder.setAttr("writer_prefix", opts.writerPrefix);
                }
                if (opts.hashValid != null) {
                    opBuilder.setAttr("hash_valid", opts.hashValid);
                }
                if (opts.hash != null) {
                    opBuilder.setAttr("hash", opts.hash);
                }
                if (opts.metadata == null) continue;
                opBuilder.setAttr("metadata", opts.metadata);
            }
        }
        return new SnapshotDataset(opBuilder.build());
    }

    public static Options compression(String compression) {
        return new Options().compression(compression);
    }

    public static Options readerPrefix(String readerPrefix) {
        return new Options().readerPrefix(readerPrefix);
    }

    public static Options writerPrefix(String writerPrefix) {
        return new Options().writerPrefix(writerPrefix);
    }

    public static Options hashValid(Boolean hashValid) {
        return new Options().hashValid(hashValid);
    }

    public static Options hash(Long hash) {
        return new Options().hash(hash);
    }

    public static Options metadata(String metadata) {
        return new Options().metadata(metadata);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=SnapshotDataset.class)
    public static class Inputs
    extends RawOpInputs<SnapshotDataset> {
        public final Operand<? extends TType> inputDataset;
        public final Operand<TString> path;
        public final Iterable<Operand<?>> readerFuncOtherArgs;
        public final Iterable<Operand<?>> shardFuncOtherArgs;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;
        public final String compression;
        public final String readerPrefix;
        public final String writerPrefix;
        public final boolean hashValid;
        public final long hash;
        public final DataType[] TreaderFuncArgs;
        public final DataType[] TshardFuncArgs;
        public final String metadata;

        public Inputs(GraphOperation op) {
            super(new SnapshotDataset(op), op, Arrays.asList("output_types", "output_shapes", "compression", "reader_prefix", "writer_prefix", "hash_valid", "hash", "Treader_func_args", "Tshard_func_args", "metadata"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            this.path = op.input(inputIndex++);
            int readerFuncOtherArgsLength = op.inputListLength("reader_func_other_args");
            this.readerFuncOtherArgs = Arrays.asList((Operand[])op.inputList(inputIndex, readerFuncOtherArgsLength));
            int shardFuncOtherArgsLength = op.inputListLength("shard_func_other_args");
            this.shardFuncOtherArgs = Arrays.asList((Operand[])op.inputList(inputIndex += readerFuncOtherArgsLength, shardFuncOtherArgsLength));
            inputIndex += shardFuncOtherArgsLength;
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.compression = op.attributes().getAttrString("compression");
            this.readerPrefix = op.attributes().getAttrString("reader_prefix");
            this.writerPrefix = op.attributes().getAttrString("writer_prefix");
            this.hashValid = op.attributes().getAttrBool("hash_valid");
            this.hash = op.attributes().getAttrInt("hash");
            this.TreaderFuncArgs = op.attributes().getAttrTypeList("Treader_func_args");
            this.TshardFuncArgs = op.attributes().getAttrTypeList("Tshard_func_args");
            this.metadata = op.attributes().getAttrString("metadata");
        }
    }

    public static class Options {
        private String compression;
        private String readerPrefix;
        private String writerPrefix;
        private Boolean hashValid;
        private Long hash;
        private String metadata;

        private Options() {
        }

        public Options compression(String compression) {
            this.compression = compression;
            return this;
        }

        public Options readerPrefix(String readerPrefix) {
            this.readerPrefix = readerPrefix;
            return this;
        }

        public Options writerPrefix(String writerPrefix) {
            this.writerPrefix = writerPrefix;
            return this;
        }

        public Options hashValid(Boolean hashValid) {
            this.hashValid = hashValid;
            return this;
        }

        public Options hash(Long hash) {
            this.hash = hash;
            return this;
        }

        public Options metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }
    }
}

