/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="Split", inputsClass=Inputs.class)
public final class Split<T extends TType>
extends RawOp
implements Iterable<Operand<T>> {
    public static final String OP_NAME = "Split";
    private List<Output<T>> output;

    public Split(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }

    public static <T extends TType> Split<T> create(Scope scope, Operand<TInt32> axis, Operand<T> value, Long numSplit) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(axis.asOutput());
        opBuilder.addInput(value.asOutput());
        opBuilder.setAttr("num_split", numSplit);
        return new Split<T>(opBuilder.build());
    }

    public List<Output<T>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<T>> iterator() {
        return this.output.iterator();
    }

    @OpInputsMetadata(outputsClass=Split.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<Split<T>> {
        public final Operand<TInt32> axis;
        public final Operand<T> value;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new Split(op), op, Arrays.asList("T"));
            int inputIndex = 0;
            this.axis = op.input(inputIndex++);
            this.value = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
        }
    }
}

