/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.collective;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="CollectiveReduceScatterV2", inputsClass=Inputs.class)
public final class CollectiveReduceScatter<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "CollectiveReduceScatterV2";
    private Output<T> data;

    public CollectiveReduceScatter(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.data = operation.output(outputIdx++);
    }

    public static <T extends TNumber> CollectiveReduceScatter<T> create(Scope scope, Operand<T> input, Operand<TInt32> groupSize, Operand<TInt32> groupKey, Operand<TInt32> instanceKey, Iterable<Operand<? extends TType>> orderingToken, String mergeOp, String finalOp, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "CollectiveReduceScatter");
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(groupSize.asOutput());
        opBuilder.addInput(groupKey.asOutput());
        opBuilder.addInput(instanceKey.asOutput());
        opBuilder.addInputList(Operands.asOutputs(orderingToken));
        opBuilder.setAttr("merge_op", mergeOp);
        opBuilder.setAttr("final_op", finalOp);
        if (options != null) {
            for (Options opts : options) {
                if (opts.communicationHint != null) {
                    opBuilder.setAttr("communication_hint", opts.communicationHint);
                }
                if (opts.timeoutSeconds != null) {
                    opBuilder.setAttr("timeout_seconds", opts.timeoutSeconds.floatValue());
                }
                if (opts.isStateless != null) {
                    opBuilder.setAttr("is_stateless", opts.isStateless);
                }
                if (opts.NorderingToken != null) {
                    opBuilder.setAttr("Nordering_token", opts.NorderingToken);
                }
                if (opts.maxSubdivsPerDevice == null) continue;
                opBuilder.setAttr("max_subdivs_per_device", opts.maxSubdivsPerDevice);
            }
        }
        return new CollectiveReduceScatter<T>(opBuilder.build());
    }

    public static Options communicationHint(String communicationHint) {
        return new Options().communicationHint(communicationHint);
    }

    public static Options timeoutSeconds(Float timeoutSeconds) {
        return new Options().timeoutSeconds(timeoutSeconds);
    }

    public static Options isStateless(Boolean isStateless) {
        return new Options().isStateless(isStateless);
    }

    public static Options NorderingToken(Long NorderingToken) {
        return new Options().NorderingToken(NorderingToken);
    }

    public static Options maxSubdivsPerDevice(Long maxSubdivsPerDevice) {
        return new Options().maxSubdivsPerDevice(maxSubdivsPerDevice);
    }

    public Output<T> data() {
        return this.data;
    }

    @Override
    public Output<T> asOutput() {
        return this.data;
    }

    @OpInputsMetadata(outputsClass=CollectiveReduceScatter.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<CollectiveReduceScatter<T>> {
        public final Operand<T> input;
        public final Operand<TInt32> groupSize;
        public final Operand<TInt32> groupKey;
        public final Operand<TInt32> instanceKey;
        public final Iterable<Operand<? extends TType>> orderingToken;
        public final DataType T;
        public final String mergeOp;
        public final String finalOp;
        public final String communicationHint;
        public final float timeoutSeconds;
        public final boolean isStateless;
        public final long maxSubdivsPerDevice;

        public Inputs(GraphOperation op) {
            super(new CollectiveReduceScatter(op), op, Arrays.asList("T", "merge_op", "final_op", "communication_hint", "timeout_seconds", "is_stateless", "max_subdivs_per_device"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.groupSize = op.input(inputIndex++);
            this.groupKey = op.input(inputIndex++);
            this.instanceKey = op.input(inputIndex++);
            int orderingTokenLength = op.inputListLength("ordering_token");
            this.orderingToken = Arrays.asList((Operand[])op.inputList(inputIndex, orderingTokenLength));
            inputIndex += orderingTokenLength;
            this.T = op.attributes().getAttrType("T");
            this.mergeOp = op.attributes().getAttrString("merge_op");
            this.finalOp = op.attributes().getAttrString("final_op");
            this.communicationHint = op.attributes().getAttrString("communication_hint");
            this.timeoutSeconds = op.attributes().getAttrFloat("timeout_seconds");
            this.isStateless = op.attributes().getAttrBool("is_stateless");
            this.maxSubdivsPerDevice = op.attributes().getAttrInt("max_subdivs_per_device");
        }
    }

    public static class Options {
        private String communicationHint;
        private Float timeoutSeconds;
        private Boolean isStateless;
        private Long NorderingToken;
        private Long maxSubdivsPerDevice;

        private Options() {
        }

        public Options communicationHint(String communicationHint) {
            this.communicationHint = communicationHint;
            return this;
        }

        public Options timeoutSeconds(Float timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public Options isStateless(Boolean isStateless) {
            this.isStateless = isStateless;
            return this;
        }

        public Options NorderingToken(Long NorderingToken) {
            this.NorderingToken = NorderingToken;
            return this;
        }

        public Options maxSubdivsPerDevice(Long maxSubdivsPerDevice) {
            this.maxSubdivsPerDevice = maxSubdivsPerDevice;
            return this;
        }
    }
}

