/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.buffer.adapter;

import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.layout.DataLayout;
import org.tensorflow.ndarray.impl.buffer.AbstractDataBuffer;
import org.tensorflow.ndarray.impl.buffer.Validator;

abstract class AbstractDataBufferAdapter<S extends DataBuffer<?>, T, U extends DataBuffer<T>>
extends AbstractDataBuffer<T> {
    private final S buffer;
    private final DataLayout<S, T> layout;
    private final long size;

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public boolean isReadOnly() {
        return this.buffer.isReadOnly();
    }

    @Override
    public T getObject(long index) {
        Validator.getArgs(this, index);
        return this.layout.readObject(this.buffer, index * (long)this.layout.scale());
    }

    public U setObject(T value, long index) {
        Validator.setArgs(this, index);
        this.layout.writeObject(this.buffer, value, index * (long)this.layout.scale());
        return (U)this;
    }

    AbstractDataBufferAdapter(S buffer, DataLayout<S, T> layout) {
        this.buffer = buffer;
        this.layout = layout;
        this.size = buffer.size() / (long)layout.scale();
    }

    DataLayout<S, T> layout() {
        return this.layout;
    }

    S buffer() {
        return this.buffer;
    }
}

