/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.buffer;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.BitSet;
import org.tensorflow.ndarray.buffer.BooleanDataBuffer;
import org.tensorflow.ndarray.buffer.ByteDataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DoubleDataBuffer;
import org.tensorflow.ndarray.buffer.FloatDataBuffer;
import org.tensorflow.ndarray.buffer.IntDataBuffer;
import org.tensorflow.ndarray.buffer.LongDataBuffer;
import org.tensorflow.ndarray.buffer.ShortDataBuffer;
import org.tensorflow.ndarray.impl.buffer.Validator;
import org.tensorflow.ndarray.impl.buffer.misc.MiscDataBufferFactory;
import org.tensorflow.ndarray.impl.buffer.nio.NioDataBufferFactory;
import org.tensorflow.ndarray.impl.buffer.raw.RawDataBufferFactory;

public final class DataBuffers {
    static long MAX_32BITS = 0x7FFFFFF5L;

    public static ByteDataBuffer ofBytes(long size) {
        Validator.createArgs(size, MAX_32BITS);
        if (RawDataBufferFactory.canBeUsed()) {
            return RawDataBufferFactory.create(new byte[(int)size], false);
        }
        return NioDataBufferFactory.create(ByteBuffer.allocate((int)size));
    }

    public static LongDataBuffer ofLongs(long size) {
        Validator.createArgs(size, MAX_32BITS);
        if (RawDataBufferFactory.canBeUsed()) {
            return RawDataBufferFactory.create(new long[(int)size], false);
        }
        return NioDataBufferFactory.create(LongBuffer.allocate((int)size));
    }

    public static IntDataBuffer ofInts(long size) {
        Validator.createArgs(size, MAX_32BITS);
        if (RawDataBufferFactory.canBeUsed()) {
            return RawDataBufferFactory.create(new int[(int)size], false);
        }
        return NioDataBufferFactory.create(IntBuffer.allocate((int)size));
    }

    public static ShortDataBuffer ofShorts(long size) {
        Validator.createArgs(size, MAX_32BITS);
        if (RawDataBufferFactory.canBeUsed()) {
            return RawDataBufferFactory.create(new short[(int)size], false);
        }
        return NioDataBufferFactory.create(ShortBuffer.allocate((int)size));
    }

    public static DoubleDataBuffer ofDoubles(long size) {
        Validator.createArgs(size, MAX_32BITS);
        if (RawDataBufferFactory.canBeUsed()) {
            return RawDataBufferFactory.create(new double[(int)size], false);
        }
        return NioDataBufferFactory.create(DoubleBuffer.allocate((int)size));
    }

    public static FloatDataBuffer ofFloats(long size) {
        Validator.createArgs(size, MAX_32BITS);
        if (RawDataBufferFactory.canBeUsed()) {
            return RawDataBufferFactory.create(new float[(int)size], false);
        }
        return NioDataBufferFactory.create(FloatBuffer.allocate((int)size));
    }

    public static BooleanDataBuffer ofBooleans(long size) {
        Validator.createArgs(size, MAX_32BITS);
        if (RawDataBufferFactory.canBeUsed()) {
            return RawDataBufferFactory.create(new boolean[(int)size], false);
        }
        return MiscDataBufferFactory.create(new BitSet((int)size), size, false);
    }

    public static <T> DataBuffer<T> ofObjects(Class<T> type, long size) {
        Validator.createArgs(size, MAX_32BITS);
        Object[] array = (Object[])Array.newInstance(type, (int)size);
        return MiscDataBufferFactory.create(array, false);
    }

    public static FloatDataBuffer of(float ... values) {
        return DataBuffers.of(values, false, false);
    }

    public static ByteDataBuffer of(byte ... values) {
        return DataBuffers.of(values, false, false);
    }

    public static LongDataBuffer of(long ... values) {
        return DataBuffers.of(values, false, false);
    }

    public static IntDataBuffer of(int ... values) {
        return DataBuffers.of(values, false, false);
    }

    public static ShortDataBuffer of(short ... values) {
        return DataBuffers.of(values, false, false);
    }

    public static DoubleDataBuffer of(double ... values) {
        return DataBuffers.of(values, false, false);
    }

    public static BooleanDataBuffer of(boolean ... values) {
        return DataBuffers.of(values, false, false);
    }

    @SafeVarargs
    public static <T> DataBuffer<T> ofObjects(T ... values) {
        return DataBuffers.of(values, false, false);
    }

    public static FloatDataBuffer of(float[] array, boolean readOnly, boolean makeCopy) {
        float[] bufferArray;
        float[] fArray = bufferArray = makeCopy ? Arrays.copyOf(array, array.length) : array;
        if (RawDataBufferFactory.canBeUsed()) {
            return RawDataBufferFactory.create(bufferArray, readOnly);
        }
        FloatBuffer buf = FloatBuffer.wrap(bufferArray);
        return NioDataBufferFactory.create(readOnly ? buf.asReadOnlyBuffer() : buf);
    }

    public static ByteDataBuffer of(byte[] array, boolean readOnly, boolean makeCopy) {
        byte[] bufferArray;
        byte[] byArray = bufferArray = makeCopy ? Arrays.copyOf(array, array.length) : array;
        if (RawDataBufferFactory.canBeUsed()) {
            return RawDataBufferFactory.create(bufferArray, readOnly);
        }
        ByteBuffer buf = ByteBuffer.wrap(bufferArray);
        return NioDataBufferFactory.create(readOnly ? buf.asReadOnlyBuffer() : buf);
    }

    public static LongDataBuffer of(long[] array, boolean readOnly, boolean makeCopy) {
        long[] bufferArray;
        long[] lArray = bufferArray = makeCopy ? Arrays.copyOf(array, array.length) : array;
        if (RawDataBufferFactory.canBeUsed()) {
            return RawDataBufferFactory.create(bufferArray, readOnly);
        }
        LongBuffer buf = LongBuffer.wrap(bufferArray);
        return NioDataBufferFactory.create(readOnly ? buf.asReadOnlyBuffer() : buf);
    }

    public static IntDataBuffer of(int[] array, boolean readOnly, boolean makeCopy) {
        int[] bufferArray;
        int[] nArray = bufferArray = makeCopy ? Arrays.copyOf(array, array.length) : array;
        if (RawDataBufferFactory.canBeUsed()) {
            return RawDataBufferFactory.create(bufferArray, readOnly);
        }
        IntBuffer buf = IntBuffer.wrap(bufferArray);
        return NioDataBufferFactory.create(readOnly ? buf.asReadOnlyBuffer() : buf);
    }

    public static ShortDataBuffer of(short[] array, boolean readOnly, boolean makeCopy) {
        short[] bufferArray;
        short[] sArray = bufferArray = makeCopy ? Arrays.copyOf(array, array.length) : array;
        if (RawDataBufferFactory.canBeUsed()) {
            return RawDataBufferFactory.create(bufferArray, readOnly);
        }
        ShortBuffer buf = ShortBuffer.wrap(bufferArray);
        return NioDataBufferFactory.create(readOnly ? buf.asReadOnlyBuffer() : buf);
    }

    public static DoubleDataBuffer of(double[] array, boolean readOnly, boolean makeCopy) {
        double[] bufferArray;
        double[] dArray = bufferArray = makeCopy ? Arrays.copyOf(array, array.length) : array;
        if (RawDataBufferFactory.canBeUsed()) {
            return RawDataBufferFactory.create(bufferArray, readOnly);
        }
        DoubleBuffer buf = DoubleBuffer.wrap(bufferArray);
        return NioDataBufferFactory.create(readOnly ? buf.asReadOnlyBuffer() : buf);
    }

    public static BooleanDataBuffer of(boolean[] array, boolean readOnly, boolean makeCopy) {
        boolean[] bufferArray;
        boolean[] blArray = bufferArray = makeCopy ? Arrays.copyOf(array, array.length) : array;
        if (RawDataBufferFactory.canBeUsed()) {
            return RawDataBufferFactory.create(bufferArray, readOnly);
        }
        return MiscDataBufferFactory.create(bufferArray, readOnly);
    }

    public static <T> DataBuffer<T> of(T[] array, boolean readOnly, boolean makeCopy) {
        T[] bufferArray = makeCopy ? Arrays.copyOf(array, array.length) : array;
        return MiscDataBufferFactory.create(bufferArray, readOnly);
    }

    public static ByteDataBuffer of(ByteBuffer buf) {
        return NioDataBufferFactory.create(buf.duplicate());
    }

    public static IntDataBuffer of(IntBuffer buf) {
        return NioDataBufferFactory.create(buf.duplicate());
    }

    public static ShortDataBuffer of(ShortBuffer buf) {
        return NioDataBufferFactory.create(buf.duplicate());
    }

    public static LongDataBuffer of(LongBuffer buf) {
        return NioDataBufferFactory.create(buf.duplicate());
    }

    public static FloatDataBuffer of(FloatBuffer buf) {
        return NioDataBufferFactory.create(buf.duplicate());
    }

    public static DoubleDataBuffer of(DoubleBuffer buf) {
        return NioDataBufferFactory.create(buf.duplicate());
    }
}

