/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TPUPartitionedOutputV2", inputsClass=Inputs.class)
public final class PartitionedOutput<T extends TType>
extends RawOp
implements Iterable<Operand<T>> {
    public static final String OP_NAME = "TPUPartitionedOutputV2";
    private List<Output<T>> output;

    public PartitionedOutput(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }

    public static <T extends TType> PartitionedOutput<T> create(Scope scope, Operand<T> inputs, Long numSplits, List<Long> partitionDims) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "PartitionedOutput");
        opBuilder.addInput(inputs.asOutput());
        opBuilder.setAttr("num_splits", numSplits);
        long[] partitionDimsArray = new long[partitionDims.size()];
        for (int i = 0; i < partitionDimsArray.length; ++i) {
            partitionDimsArray[i] = partitionDims.get(i);
        }
        opBuilder.setAttr("partition_dims", partitionDimsArray);
        return new PartitionedOutput<T>(opBuilder.build());
    }

    public List<Output<T>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<T>> iterator() {
        return this.output.iterator();
    }

    @OpInputsMetadata(outputsClass=PartitionedOutput.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<PartitionedOutput<T>> {
        public final Operand<T> inputs;
        public final DataType T;
        public final long[] partitionDims;

        public Inputs(GraphOperation op) {
            super(new PartitionedOutput(op), op, Arrays.asList("T", "partition_dims"));
            int inputIndex = 0;
            this.inputs = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.partitionDims = op.attributes().getAttrIntList("partition_dims");
        }
    }
}

