/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;

@OpMetadata(opType="TPUCompile", inputsClass=Inputs.class)
public final class Compile
extends RawOp {
    public static final String OP_NAME = "TPUCompile";
    private Output<TString> compilationStatus;
    private List<Output<TString>> program;
    private List<Output<TBool>> mayModifyVariables;

    public Compile(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.compilationStatus = operation.output(outputIdx++);
        int programLength = operation.outputListLength("program");
        this.program = Arrays.asList(operation.outputList(outputIdx, programLength));
        int mayModifyVariablesLength = operation.outputListLength("may_modify_variables");
        this.mayModifyVariables = Arrays.asList(operation.outputList(outputIdx += programLength, mayModifyVariablesLength));
        outputIdx += mayModifyVariablesLength;
    }

    public static Compile create(Scope scope, Iterable<Operand<TInt64>> dynamicShapes, Iterable<Operand<?>> guaranteedConstants, Long numComputations, ConcreteFunction function, String metadata) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Compile");
        opBuilder.addInputList(Operands.asOutputs(dynamicShapes));
        opBuilder.addInputList(Operands.asOutputs(guaranteedConstants));
        opBuilder.setAttr("num_computations", numComputations);
        opBuilder.setAttr("function", function);
        opBuilder.setAttr("metadata", metadata);
        return new Compile(opBuilder.build());
    }

    public Output<TString> compilationStatus() {
        return this.compilationStatus;
    }

    public List<Output<TString>> program() {
        return this.program;
    }

    public List<Output<TBool>> mayModifyVariables() {
        return this.mayModifyVariables;
    }

    @OpInputsMetadata(outputsClass=Compile.class)
    public static class Inputs
    extends RawOpInputs<Compile> {
        public final Iterable<Operand<TInt64>> dynamicShapes;
        public final Iterable<Operand<?>> guaranteedConstants;
        public final String metadata;
        public final DataType[] TguaranteedConstants;

        public Inputs(GraphOperation op) {
            super(new Compile(op), op, Arrays.asList("metadata", "Tguaranteed_constants"));
            int inputIndex = 0;
            int dynamicShapesLength = op.inputListLength("dynamic_shapes");
            this.dynamicShapes = Arrays.asList((Operand[])op.inputList(inputIndex, dynamicShapesLength));
            int guaranteedConstantsLength = op.inputListLength("guaranteed_constants");
            this.guaranteedConstants = Arrays.asList((Operand[])op.inputList(inputIndex += dynamicShapesLength, guaranteedConstantsLength));
            inputIndex += guaranteedConstantsLength;
            this.metadata = op.attributes().getAttrString("metadata");
            this.TguaranteedConstants = op.attributes().getAttrTypeList("Tguaranteed_constants");
        }
    }
}

